//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package generated

import (
	"context"
	"encoding/base64"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"io"
	"net/http"
	"strconv"
	"strings"
	"time"
)

// FileClient contains the methods for the File group.
// Don't use this type directly, use a constructor function instead.
type FileClient struct {
	internal               *azcore.Client
	endpoint               string
	allowTrailingDot       *bool
	fileRequestIntent      *ShareTokenIntent
	allowSourceTrailingDot *bool
}

// AbortCopy - Aborts a pending Copy File operation, and leaves a destination file with zero length and full metadata.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - copyID - The copy identifier provided in the x-ms-copy-id header of the original Copy File operation.
//   - options - FileClientAbortCopyOptions contains the optional parameters for the FileClient.AbortCopy method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) AbortCopy(ctx context.Context, copyID string, options *FileClientAbortCopyOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientAbortCopyResponse, error) {
	var err error
	req, err := client.abortCopyCreateRequest(ctx, copyID, options, leaseAccessConditions)
	if err != nil {
		return FileClientAbortCopyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientAbortCopyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return FileClientAbortCopyResponse{}, err
	}
	resp, err := client.abortCopyHandleResponse(httpResp)
	return resp, err
}

// abortCopyCreateRequest creates the AbortCopy request.
func (client *FileClient) abortCopyCreateRequest(ctx context.Context, copyID string, options *FileClientAbortCopyOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "copy")
	reqQP.Set("copyid", copyID)
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-copy-action"] = []string{"abort"}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// abortCopyHandleResponse handles the AbortCopy response.
func (client *FileClient) abortCopyHandleResponse(resp *http.Response) (FileClientAbortCopyResponse, error) {
	result := FileClientAbortCopyResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientAbortCopyResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// AcquireLease - [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - duration - Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires. A non-infinite
//     lease can be between 15 and 60 seconds. A lease duration cannot be changed using
//     renew or change.
//   - options - FileClientAcquireLeaseOptions contains the optional parameters for the FileClient.AcquireLease method.
func (client *FileClient) AcquireLease(ctx context.Context, duration int32, options *FileClientAcquireLeaseOptions) (FileClientAcquireLeaseResponse, error) {
	var err error
	req, err := client.acquireLeaseCreateRequest(ctx, duration, options)
	if err != nil {
		return FileClientAcquireLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientAcquireLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FileClientAcquireLeaseResponse{}, err
	}
	resp, err := client.acquireLeaseHandleResponse(httpResp)
	return resp, err
}

// acquireLeaseCreateRequest creates the AcquireLease request.
func (client *FileClient) acquireLeaseCreateRequest(ctx context.Context, duration int32, options *FileClientAcquireLeaseOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"acquire"}
	req.Raw().Header["x-ms-lease-duration"] = []string{strconv.FormatInt(int64(duration), 10)}
	if options != nil && options.ProposedLeaseID != nil {
		req.Raw().Header["x-ms-proposed-lease-id"] = []string{*options.ProposedLeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// acquireLeaseHandleResponse handles the AcquireLease response.
func (client *FileClient) acquireLeaseHandleResponse(resp *http.Response) (FileClientAcquireLeaseResponse, error) {
	result := FileClientAcquireLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientAcquireLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientAcquireLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// BreakLease - [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientBreakLeaseOptions contains the optional parameters for the FileClient.BreakLease method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) BreakLease(ctx context.Context, options *FileClientBreakLeaseOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientBreakLeaseResponse, error) {
	var err error
	req, err := client.breakLeaseCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return FileClientBreakLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientBreakLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return FileClientBreakLeaseResponse{}, err
	}
	resp, err := client.breakLeaseHandleResponse(httpResp)
	return resp, err
}

// breakLeaseCreateRequest creates the BreakLease request.
func (client *FileClient) breakLeaseCreateRequest(ctx context.Context, options *FileClientBreakLeaseOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"break"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// breakLeaseHandleResponse handles the BreakLease response.
func (client *FileClient) breakLeaseHandleResponse(resp *http.Response) (FileClientBreakLeaseResponse, error) {
	result := FileClientBreakLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientBreakLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientBreakLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// ChangeLease - [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - leaseID - Specifies the current lease ID on the resource.
//   - options - FileClientChangeLeaseOptions contains the optional parameters for the FileClient.ChangeLease method.
func (client *FileClient) ChangeLease(ctx context.Context, leaseID string, options *FileClientChangeLeaseOptions) (FileClientChangeLeaseResponse, error) {
	var err error
	req, err := client.changeLeaseCreateRequest(ctx, leaseID, options)
	if err != nil {
		return FileClientChangeLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientChangeLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientChangeLeaseResponse{}, err
	}
	resp, err := client.changeLeaseHandleResponse(httpResp)
	return resp, err
}

// changeLeaseCreateRequest creates the ChangeLease request.
func (client *FileClient) changeLeaseCreateRequest(ctx context.Context, leaseID string, options *FileClientChangeLeaseOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"change"}
	req.Raw().Header["x-ms-lease-id"] = []string{leaseID}
	if options != nil && options.ProposedLeaseID != nil {
		req.Raw().Header["x-ms-proposed-lease-id"] = []string{*options.ProposedLeaseID}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// changeLeaseHandleResponse handles the ChangeLease response.
func (client *FileClient) changeLeaseHandleResponse(resp *http.Response) (FileClientChangeLeaseResponse, error) {
	result := FileClientChangeLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientChangeLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientChangeLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-id"); val != "" {
		result.LeaseID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Create - Creates a new file or replaces a file. Note it only initializes the file with no content.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - fileContentLength - Specifies the maximum size for the file, up to 4 TB.
//   - options - FileClientCreateOptions contains the optional parameters for the FileClient.Create method.
//   - ShareFileHTTPHeaders - ShareFileHTTPHeaders contains a group of parameters for the FileClient.Create method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) Create(ctx context.Context, fileContentLength int64, options *FileClientCreateOptions, shareFileHTTPHeaders *ShareFileHTTPHeaders, leaseAccessConditions *LeaseAccessConditions) (FileClientCreateResponse, error) {
	var err error
	req, err := client.createCreateRequest(ctx, fileContentLength, options, shareFileHTTPHeaders, leaseAccessConditions)
	if err != nil {
		return FileClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FileClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *FileClient) createCreateRequest(ctx context.Context, fileContentLength int64, options *FileClientCreateOptions, shareFileHTTPHeaders *ShareFileHTTPHeaders, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	req.Raw().Header["x-ms-content-length"] = []string{strconv.FormatInt(fileContentLength, 10)}
	req.Raw().Header["x-ms-type"] = []string{"file"}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentType != nil {
		req.Raw().Header["x-ms-content-type"] = []string{*shareFileHTTPHeaders.ContentType}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentEncoding != nil {
		req.Raw().Header["x-ms-content-encoding"] = []string{*shareFileHTTPHeaders.ContentEncoding}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentLanguage != nil {
		req.Raw().Header["x-ms-content-language"] = []string{*shareFileHTTPHeaders.ContentLanguage}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.CacheControl != nil {
		req.Raw().Header["x-ms-cache-control"] = []string{*shareFileHTTPHeaders.CacheControl}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentMD5 != nil {
		req.Raw().Header["x-ms-content-md5"] = []string{base64.StdEncoding.EncodeToString(shareFileHTTPHeaders.ContentMD5)}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentDisposition != nil {
		req.Raw().Header["x-ms-content-disposition"] = []string{*shareFileHTTPHeaders.ContentDisposition}
	}
	if options != nil && options.Metadata != nil {
		for k, v := range options.Metadata {
			if v != nil {
				req.Raw().Header["x-ms-meta-"+k] = []string{*v}
			}
		}
	}
	if options != nil && options.FilePermission != nil {
		req.Raw().Header["x-ms-file-permission"] = []string{*options.FilePermission}
	}
	if options != nil && options.FilePermissionFormat != nil {
		req.Raw().Header["x-ms-file-permission-format"] = []string{string(*options.FilePermissionFormat)}
	}
	if options != nil && options.FilePermissionKey != nil {
		req.Raw().Header["x-ms-file-permission-key"] = []string{*options.FilePermissionKey}
	}
	if options != nil && options.FileAttributes != nil {
		req.Raw().Header["x-ms-file-attributes"] = []string{*options.FileAttributes}
	}
	if options != nil && options.FileCreationTime != nil {
		req.Raw().Header["x-ms-file-creation-time"] = []string{*options.FileCreationTime}
	}
	if options != nil && options.FileLastWriteTime != nil {
		req.Raw().Header["x-ms-file-last-write-time"] = []string{*options.FileLastWriteTime}
	}
	if options != nil && options.FileChangeTime != nil {
		req.Raw().Header["x-ms-file-change-time"] = []string{*options.FileChangeTime}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	if options != nil && options.Owner != nil {
		req.Raw().Header["x-ms-owner"] = []string{*options.Owner}
	}
	if options != nil && options.Group != nil {
		req.Raw().Header["x-ms-group"] = []string{*options.Group}
	}
	if options != nil && options.FileMode != nil {
		req.Raw().Header["x-ms-mode"] = []string{*options.FileMode}
	}
	if options != nil && options.NFSFileType != nil {
		req.Raw().Header["x-ms-file-file-type"] = []string{string(*options.NFSFileType)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *FileClient) createHandleResponse(resp *http.Response) (FileClientCreateResponse, error) {
	result := FileClientCreateResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientCreateResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-attributes"); val != "" {
		result.FileAttributes = &val
	}
	if val := resp.Header.Get("x-ms-file-change-time"); val != "" {
		fileChangeTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateResponse{}, err
		}
		result.FileChangeTime = &fileChangeTime
	}
	if val := resp.Header.Get("x-ms-file-creation-time"); val != "" {
		fileCreationTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateResponse{}, err
		}
		result.FileCreationTime = &fileCreationTime
	}
	if val := resp.Header.Get("x-ms-file-id"); val != "" {
		result.ID = &val
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-mode"); val != "" {
		result.FileMode = &val
	}
	if val := resp.Header.Get("x-ms-file-parent-id"); val != "" {
		result.ParentID = &val
	}
	if val := resp.Header.Get("x-ms-file-permission-key"); val != "" {
		result.FilePermissionKey = &val
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.Group = &val
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return FileClientCreateResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientCreateResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-file-file-type"); val != "" {
		result.NFSFileType = (*NFSFileType)(&val)
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.Owner = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// CreateHardLink - Creates a hard link.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - targetFile - NFS only. Required. Specifies the path of the target file to which the link will be created, up to 2 KiB in
//     length. It should be full path of the target from the root.The target file must be in the
//     same share and hence the same storage account.
//   - options - FileClientCreateHardLinkOptions contains the optional parameters for the FileClient.CreateHardLink method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) CreateHardLink(ctx context.Context, targetFile string, options *FileClientCreateHardLinkOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientCreateHardLinkResponse, error) {
	var err error
	req, err := client.createHardLinkCreateRequest(ctx, targetFile, options, leaseAccessConditions)
	if err != nil {
		return FileClientCreateHardLinkResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientCreateHardLinkResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FileClientCreateHardLinkResponse{}, err
	}
	resp, err := client.createHardLinkHandleResponse(httpResp)
	return resp, err
}

// createHardLinkCreateRequest creates the CreateHardLink request.
func (client *FileClient) createHardLinkCreateRequest(ctx context.Context, targetFile string, options *FileClientCreateHardLinkOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "hardlink")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	req.Raw().Header["x-ms-type"] = []string{"file"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	req.Raw().Header["x-ms-file-target-file"] = []string{targetFile}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// createHardLinkHandleResponse handles the CreateHardLink response.
func (client *FileClient) createHardLinkHandleResponse(resp *http.Response) (FileClientCreateHardLinkResponse, error) {
	result := FileClientCreateHardLinkResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientCreateHardLinkResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-change-time"); val != "" {
		fileChangeTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateHardLinkResponse{}, err
		}
		result.FileChangeTime = &fileChangeTime
	}
	if val := resp.Header.Get("x-ms-file-creation-time"); val != "" {
		fileCreationTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateHardLinkResponse{}, err
		}
		result.FileCreationTime = &fileCreationTime
	}
	if val := resp.Header.Get("x-ms-file-id"); val != "" {
		result.ID = &val
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateHardLinkResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-mode"); val != "" {
		result.FileMode = &val
	}
	if val := resp.Header.Get("x-ms-file-parent-id"); val != "" {
		result.ParentID = &val
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.Group = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientCreateHardLinkResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-link-count"); val != "" {
		linkCount, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientCreateHardLinkResponse{}, err
		}
		result.LinkCount = &linkCount
	}
	if val := resp.Header.Get("x-ms-file-file-type"); val != "" {
		result.NFSFileType = (*NFSFileType)(&val)
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.Owner = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// CreateSymbolicLink - Creates a symbolic link.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - linkText - NFS only. Required. The path to the original file, the symbolic link is pointing to. The path is of type string
//     which is not resolved and is stored as is. The path can be absolute path or the relative
//     path depending on the content stored in the symbolic link file.
//   - options - FileClientCreateSymbolicLinkOptions contains the optional parameters for the FileClient.CreateSymbolicLink method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) CreateSymbolicLink(ctx context.Context, linkText string, options *FileClientCreateSymbolicLinkOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientCreateSymbolicLinkResponse, error) {
	var err error
	req, err := client.createSymbolicLinkCreateRequest(ctx, linkText, options, leaseAccessConditions)
	if err != nil {
		return FileClientCreateSymbolicLinkResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientCreateSymbolicLinkResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FileClientCreateSymbolicLinkResponse{}, err
	}
	resp, err := client.createSymbolicLinkHandleResponse(httpResp)
	return resp, err
}

// createSymbolicLinkCreateRequest creates the CreateSymbolicLink request.
func (client *FileClient) createSymbolicLinkCreateRequest(ctx context.Context, linkText string, options *FileClientCreateSymbolicLinkOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "symboliclink")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.Metadata != nil {
		for k, v := range options.Metadata {
			if v != nil {
				req.Raw().Header["x-ms-meta-"+k] = []string{*v}
			}
		}
	}
	if options != nil && options.FileCreationTime != nil {
		req.Raw().Header["x-ms-file-creation-time"] = []string{*options.FileCreationTime}
	}
	if options != nil && options.FileLastWriteTime != nil {
		req.Raw().Header["x-ms-file-last-write-time"] = []string{*options.FileLastWriteTime}
	}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.Owner != nil {
		req.Raw().Header["x-ms-owner"] = []string{*options.Owner}
	}
	if options != nil && options.Group != nil {
		req.Raw().Header["x-ms-group"] = []string{*options.Group}
	}
	req.Raw().Header["x-ms-link-text"] = []string{linkText}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// createSymbolicLinkHandleResponse handles the CreateSymbolicLink response.
func (client *FileClient) createSymbolicLinkHandleResponse(resp *http.Response) (FileClientCreateSymbolicLinkResponse, error) {
	result := FileClientCreateSymbolicLinkResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientCreateSymbolicLinkResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-change-time"); val != "" {
		fileChangeTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateSymbolicLinkResponse{}, err
		}
		result.FileChangeTime = &fileChangeTime
	}
	if val := resp.Header.Get("x-ms-file-creation-time"); val != "" {
		fileCreationTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateSymbolicLinkResponse{}, err
		}
		result.FileCreationTime = &fileCreationTime
	}
	if val := resp.Header.Get("x-ms-file-id"); val != "" {
		result.ID = &val
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientCreateSymbolicLinkResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-mode"); val != "" {
		result.FileMode = &val
	}
	if val := resp.Header.Get("x-ms-file-parent-id"); val != "" {
		result.ParentID = &val
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.Group = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientCreateSymbolicLinkResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-file-file-type"); val != "" {
		result.NFSFileType = (*NFSFileType)(&val)
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.Owner = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Delete - removes the file from the storage account.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientDeleteOptions contains the optional parameters for the FileClient.Delete method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) Delete(ctx context.Context, options *FileClientDeleteOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientDeleteResponse, error) {
	var err error
	req, err := client.deleteCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return FileClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return FileClientDeleteResponse{}, err
	}
	resp, err := client.deleteHandleResponse(httpResp)
	return resp, err
}

// deleteCreateRequest creates the Delete request.
func (client *FileClient) deleteCreateRequest(ctx context.Context, options *FileClientDeleteOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodDelete, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *FileClient) deleteHandleResponse(resp *http.Response) (FileClientDeleteResponse, error) {
	result := FileClientDeleteResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientDeleteResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-link-count"); val != "" {
		linkCount, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientDeleteResponse{}, err
		}
		result.LinkCount = &linkCount
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Download - Reads or downloads a file from the system, including its metadata and properties.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientDownloadOptions contains the optional parameters for the FileClient.Download method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) Download(ctx context.Context, options *FileClientDownloadOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientDownloadResponse, error) {
	var err error
	req, err := client.downloadCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return FileClientDownloadResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientDownloadResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusPartialContent) {
		err = runtime.NewResponseError(httpResp)
		return FileClientDownloadResponse{}, err
	}
	resp, err := client.downloadHandleResponse(httpResp)
	return resp, err
}

// downloadCreateRequest creates the Download request.
func (client *FileClient) downloadCreateRequest(ctx context.Context, options *FileClientDownloadOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	runtime.SkipBodyDownload(req)
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.Range != nil {
		req.Raw().Header["x-ms-range"] = []string{*options.Range}
	}
	if options != nil && options.RangeGetContentMD5 != nil {
		req.Raw().Header["x-ms-range-get-content-md5"] = []string{strconv.FormatBool(*options.RangeGetContentMD5)}
	}
	if options != nil && options.StructuredBodyType != nil {
		req.Raw().Header["x-ms-structured-body"] = []string{*options.StructuredBodyType}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// downloadHandleResponse handles the Download response.
func (client *FileClient) downloadHandleResponse(resp *http.Response) (FileClientDownloadResponse, error) {
	result := FileClientDownloadResponse{Body: resp.Body}
	if val := resp.Header.Get("Accept-Ranges"); val != "" {
		result.AcceptRanges = &val
	}
	if val := resp.Header.Get("Cache-Control"); val != "" {
		result.CacheControl = &val
	}
	if val := resp.Header.Get("Content-Disposition"); val != "" {
		result.ContentDisposition = &val
	}
	if val := resp.Header.Get("Content-Encoding"); val != "" {
		result.ContentEncoding = &val
	}
	if val := resp.Header.Get("Content-Language"); val != "" {
		result.ContentLanguage = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("Content-Range"); val != "" {
		result.ContentRange = &val
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("x-ms-copy-completion-time"); val != "" {
		copyCompletionTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.CopyCompletionTime = &copyCompletionTime
	}
	if val := resp.Header.Get("x-ms-copy-id"); val != "" {
		result.CopyID = &val
	}
	if val := resp.Header.Get("x-ms-copy-progress"); val != "" {
		result.CopyProgress = &val
	}
	if val := resp.Header.Get("x-ms-copy-source"); val != "" {
		result.CopySource = &val
	}
	if val := resp.Header.Get("x-ms-copy-status"); val != "" {
		result.CopyStatus = (*CopyStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-copy-status-description"); val != "" {
		result.CopyStatusDescription = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-attributes"); val != "" {
		result.FileAttributes = &val
	}
	if val := resp.Header.Get("x-ms-file-change-time"); val != "" {
		fileChangeTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.FileChangeTime = &fileChangeTime
	}
	if val := resp.Header.Get("x-ms-content-md5"); val != "" {
		fileContentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.FileContentMD5 = fileContentMD5
	}
	if val := resp.Header.Get("x-ms-file-creation-time"); val != "" {
		fileCreationTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.FileCreationTime = &fileCreationTime
	}
	if val := resp.Header.Get("x-ms-file-id"); val != "" {
		result.ID = &val
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-mode"); val != "" {
		result.FileMode = &val
	}
	if val := resp.Header.Get("x-ms-file-parent-id"); val != "" {
		result.ParentID = &val
	}
	if val := resp.Header.Get("x-ms-file-permission-key"); val != "" {
		result.FilePermissionKey = &val
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.Group = &val
	}
	if val := resp.Header.Get("x-ms-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = (*LeaseDurationType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = (*LeaseStateType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = (*LeaseStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-link-count"); val != "" {
		linkCount, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.LinkCount = &linkCount
	}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-meta-") && strings.EqualFold(hh[:len("x-ms-meta-")], "x-ms-meta-") {
			if result.Metadata == nil {
				result.Metadata = map[string]*string{}
			}
			result.Metadata[hh[len("x-ms-meta-"):]] = to.Ptr(resp.Header.Get(hh))
		}
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.Owner = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-structured-body"); val != "" {
		result.StructuredBodyType = &val
	}
	if val := resp.Header.Get("x-ms-structured-content-length"); val != "" {
		structuredContentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientDownloadResponse{}, err
		}
		result.StructuredContentLength = &structuredContentLength
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// ForceCloseHandles - Closes all handles open for given file
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - handleID - Specifies handle ID opened on the file or directory to be closed. Asterisk (‘*’) is a wildcard that specifies
//     all handles.
//   - options - FileClientForceCloseHandlesOptions contains the optional parameters for the FileClient.ForceCloseHandles method.
func (client *FileClient) ForceCloseHandles(ctx context.Context, handleID string, options *FileClientForceCloseHandlesOptions) (FileClientForceCloseHandlesResponse, error) {
	var err error
	req, err := client.forceCloseHandlesCreateRequest(ctx, handleID, options)
	if err != nil {
		return FileClientForceCloseHandlesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientForceCloseHandlesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientForceCloseHandlesResponse{}, err
	}
	resp, err := client.forceCloseHandlesHandleResponse(httpResp)
	return resp, err
}

// forceCloseHandlesCreateRequest creates the ForceCloseHandles request.
func (client *FileClient) forceCloseHandlesCreateRequest(ctx context.Context, handleID string, options *FileClientForceCloseHandlesOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "forceclosehandles")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Marker != nil {
		reqQP.Set("marker", *options.Marker)
	}
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-handle-id"] = []string{handleID}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// forceCloseHandlesHandleResponse handles the ForceCloseHandles response.
func (client *FileClient) forceCloseHandlesHandleResponse(resp *http.Response) (FileClientForceCloseHandlesResponse, error) {
	result := FileClientForceCloseHandlesResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientForceCloseHandlesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-marker"); val != "" {
		result.Marker = &val
	}
	if val := resp.Header.Get("x-ms-number-of-handles-closed"); val != "" {
		numberOfHandlesClosed32, err := strconv.ParseInt(val, 10, 32)
		numberOfHandlesClosed := int32(numberOfHandlesClosed32)
		if err != nil {
			return FileClientForceCloseHandlesResponse{}, err
		}
		result.NumberOfHandlesClosed = &numberOfHandlesClosed
	}
	if val := resp.Header.Get("x-ms-number-of-handles-failed"); val != "" {
		numberOfHandlesFailedToClose32, err := strconv.ParseInt(val, 10, 32)
		numberOfHandlesFailedToClose := int32(numberOfHandlesFailedToClose32)
		if err != nil {
			return FileClientForceCloseHandlesResponse{}, err
		}
		result.NumberOfHandlesFailedToClose = &numberOfHandlesFailedToClose
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// GetProperties - Returns all user-defined metadata, standard HTTP properties, and system properties for the file. It does
// not return the content of the file.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientGetPropertiesOptions contains the optional parameters for the FileClient.GetProperties method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) GetProperties(ctx context.Context, options *FileClientGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientGetPropertiesResponse, error) {
	var err error
	req, err := client.getPropertiesCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return FileClientGetPropertiesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientGetPropertiesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientGetPropertiesResponse{}, err
	}
	resp, err := client.getPropertiesHandleResponse(httpResp)
	return resp, err
}

// getPropertiesCreateRequest creates the GetProperties request.
func (client *FileClient) getPropertiesCreateRequest(ctx context.Context, options *FileClientGetPropertiesOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodHead, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// getPropertiesHandleResponse handles the GetProperties response.
func (client *FileClient) getPropertiesHandleResponse(resp *http.Response) (FileClientGetPropertiesResponse, error) {
	result := FileClientGetPropertiesResponse{}
	if val := resp.Header.Get("Cache-Control"); val != "" {
		result.CacheControl = &val
	}
	if val := resp.Header.Get("Content-Disposition"); val != "" {
		result.ContentDisposition = &val
	}
	if val := resp.Header.Get("Content-Encoding"); val != "" {
		result.ContentEncoding = &val
	}
	if val := resp.Header.Get("Content-Language"); val != "" {
		result.ContentLanguage = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("x-ms-copy-completion-time"); val != "" {
		copyCompletionTime, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.CopyCompletionTime = &copyCompletionTime
	}
	if val := resp.Header.Get("x-ms-copy-id"); val != "" {
		result.CopyID = &val
	}
	if val := resp.Header.Get("x-ms-copy-progress"); val != "" {
		result.CopyProgress = &val
	}
	if val := resp.Header.Get("x-ms-copy-source"); val != "" {
		result.CopySource = &val
	}
	if val := resp.Header.Get("x-ms-copy-status"); val != "" {
		result.CopyStatus = (*CopyStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-copy-status-description"); val != "" {
		result.CopyStatusDescription = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-attributes"); val != "" {
		result.FileAttributes = &val
	}
	if val := resp.Header.Get("x-ms-file-change-time"); val != "" {
		fileChangeTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.FileChangeTime = &fileChangeTime
	}
	if val := resp.Header.Get("x-ms-file-creation-time"); val != "" {
		fileCreationTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.FileCreationTime = &fileCreationTime
	}
	if val := resp.Header.Get("x-ms-file-id"); val != "" {
		result.ID = &val
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-mode"); val != "" {
		result.FileMode = &val
	}
	if val := resp.Header.Get("x-ms-file-parent-id"); val != "" {
		result.ParentID = &val
	}
	if val := resp.Header.Get("x-ms-file-permission-key"); val != "" {
		result.FilePermissionKey = &val
	}
	if val := resp.Header.Get("x-ms-type"); val != "" {
		result.FileType = &val
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.Group = &val
	}
	if val := resp.Header.Get("x-ms-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-lease-duration"); val != "" {
		result.LeaseDuration = (*LeaseDurationType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-state"); val != "" {
		result.LeaseState = (*LeaseStateType)(&val)
	}
	if val := resp.Header.Get("x-ms-lease-status"); val != "" {
		result.LeaseStatus = (*LeaseStatusType)(&val)
	}
	if val := resp.Header.Get("x-ms-link-count"); val != "" {
		linkCount, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientGetPropertiesResponse{}, err
		}
		result.LinkCount = &linkCount
	}
	for hh := range resp.Header {
		if len(hh) > len("x-ms-meta-") && strings.EqualFold(hh[:len("x-ms-meta-")], "x-ms-meta-") {
			if result.Metadata == nil {
				result.Metadata = map[string]*string{}
			}
			result.Metadata[hh[len("x-ms-meta-"):]] = to.Ptr(resp.Header.Get(hh))
		}
	}
	if val := resp.Header.Get("x-ms-file-file-type"); val != "" {
		result.NFSFileType = (*NFSFileType)(&val)
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.Owner = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// GetRangeList - Returns the list of valid ranges for a file.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientGetRangeListOptions contains the optional parameters for the FileClient.GetRangeList method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) GetRangeList(ctx context.Context, options *FileClientGetRangeListOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientGetRangeListResponse, error) {
	var err error
	req, err := client.getRangeListCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return FileClientGetRangeListResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientGetRangeListResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientGetRangeListResponse{}, err
	}
	resp, err := client.getRangeListHandleResponse(httpResp)
	return resp, err
}

// getRangeListCreateRequest creates the GetRangeList request.
func (client *FileClient) getRangeListCreateRequest(ctx context.Context, options *FileClientGetRangeListOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "rangelist")
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	if options != nil && options.Prevsharesnapshot != nil {
		reqQP.Set("prevsharesnapshot", *options.Prevsharesnapshot)
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.Range != nil {
		req.Raw().Header["x-ms-range"] = []string{*options.Range}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	if options != nil && options.SupportRename != nil {
		req.Raw().Header["x-ms-file-support-rename"] = []string{strconv.FormatBool(*options.SupportRename)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// getRangeListHandleResponse handles the GetRangeList response.
func (client *FileClient) getRangeListHandleResponse(resp *http.Response) (FileClientGetRangeListResponse, error) {
	result := FileClientGetRangeListResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientGetRangeListResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-content-length"); val != "" {
		fileContentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientGetRangeListResponse{}, err
		}
		result.FileContentLength = &fileContentLength
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientGetRangeListResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if err := runtime.UnmarshalAsXML(resp, &result.ShareFileRangeList); err != nil {
		return FileClientGetRangeListResponse{}, err
	}
	return result, nil
}

// GetSymbolicLink -
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientGetSymbolicLinkOptions contains the optional parameters for the FileClient.GetSymbolicLink method.
func (client *FileClient) GetSymbolicLink(ctx context.Context, options *FileClientGetSymbolicLinkOptions) (FileClientGetSymbolicLinkResponse, error) {
	var err error
	req, err := client.getSymbolicLinkCreateRequest(ctx, options)
	if err != nil {
		return FileClientGetSymbolicLinkResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientGetSymbolicLinkResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientGetSymbolicLinkResponse{}, err
	}
	resp, err := client.getSymbolicLinkHandleResponse(httpResp)
	return resp, err
}

// getSymbolicLinkCreateRequest creates the GetSymbolicLink request.
func (client *FileClient) getSymbolicLinkCreateRequest(ctx context.Context, options *FileClientGetSymbolicLinkOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("restype", "symboliclink")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// getSymbolicLinkHandleResponse handles the GetSymbolicLink response.
func (client *FileClient) getSymbolicLinkHandleResponse(resp *http.Response) (FileClientGetSymbolicLinkResponse, error) {
	result := FileClientGetSymbolicLinkResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientGetSymbolicLinkResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientGetSymbolicLinkResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-link-text"); val != "" {
		result.LinkText = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// ListHandles - Lists handles for file
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientListHandlesOptions contains the optional parameters for the FileClient.ListHandles method.
func (client *FileClient) ListHandles(ctx context.Context, options *FileClientListHandlesOptions) (FileClientListHandlesResponse, error) {
	var err error
	req, err := client.listHandlesCreateRequest(ctx, options)
	if err != nil {
		return FileClientListHandlesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientListHandlesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientListHandlesResponse{}, err
	}
	resp, err := client.listHandlesHandleResponse(httpResp)
	return resp, err
}

// listHandlesCreateRequest creates the ListHandles request.
func (client *FileClient) listHandlesCreateRequest(ctx context.Context, options *FileClientListHandlesOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodGet, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "listhandles")
	if options != nil && options.Marker != nil {
		reqQP.Set("marker", *options.Marker)
	}
	if options != nil && options.Maxresults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.Maxresults), 10))
	}
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	if options != nil && options.Sharesnapshot != nil {
		reqQP.Set("sharesnapshot", *options.Sharesnapshot)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// listHandlesHandleResponse handles the ListHandles response.
func (client *FileClient) listHandlesHandleResponse(resp *http.Response) (FileClientListHandlesResponse, error) {
	result := FileClientListHandlesResponse{}
	if val := resp.Header.Get("Content-Type"); val != "" {
		result.ContentType = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientListHandlesResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if err := runtime.UnmarshalAsXML(resp, &result.ListHandlesResponse); err != nil {
		return FileClientListHandlesResponse{}, err
	}
	return result, nil
}

// ReleaseLease - [Update] The Lease File operation establishes and manages a lock on a file for write and delete operations
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - leaseID - Specifies the current lease ID on the resource.
//   - options - FileClientReleaseLeaseOptions contains the optional parameters for the FileClient.ReleaseLease method.
func (client *FileClient) ReleaseLease(ctx context.Context, leaseID string, options *FileClientReleaseLeaseOptions) (FileClientReleaseLeaseResponse, error) {
	var err error
	req, err := client.releaseLeaseCreateRequest(ctx, leaseID, options)
	if err != nil {
		return FileClientReleaseLeaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientReleaseLeaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientReleaseLeaseResponse{}, err
	}
	resp, err := client.releaseLeaseHandleResponse(httpResp)
	return resp, err
}

// releaseLeaseCreateRequest creates the ReleaseLease request.
func (client *FileClient) releaseLeaseCreateRequest(ctx context.Context, leaseID string, options *FileClientReleaseLeaseOptions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "lease")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-lease-action"] = []string{"release"}
	req.Raw().Header["x-ms-lease-id"] = []string{leaseID}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.RequestID != nil {
		req.Raw().Header["x-ms-client-request-id"] = []string{*options.RequestID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// releaseLeaseHandleResponse handles the ReleaseLease response.
func (client *FileClient) releaseLeaseHandleResponse(resp *http.Response) (FileClientReleaseLeaseResponse, error) {
	result := FileClientReleaseLeaseResponse{}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientReleaseLeaseResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientReleaseLeaseResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Rename - Renames a file
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - renameSource - Required. Specifies the URI-style path of the source file, up to 2 KB in length.
//   - options - FileClientRenameOptions contains the optional parameters for the FileClient.Rename method.
//   - SourceLeaseAccessConditions - SourceLeaseAccessConditions contains a group of parameters for the DirectoryClient.Rename
//     method.
//   - DestinationLeaseAccessConditions - DestinationLeaseAccessConditions contains a group of parameters for the DirectoryClient.Rename
//     method.
//   - CopyFileSMBInfo - CopyFileSMBInfo contains a group of parameters for the DirectoryClient.Rename method.
//   - ShareFileHTTPHeaders - ShareFileHTTPHeaders contains a group of parameters for the FileClient.Create method.
func (client *FileClient) Rename(ctx context.Context, renameSource string, options *FileClientRenameOptions, sourceLeaseAccessConditions *SourceLeaseAccessConditions, destinationLeaseAccessConditions *DestinationLeaseAccessConditions, copyFileSMBInfo *CopyFileSMBInfo, shareFileHTTPHeaders *ShareFileHTTPHeaders) (FileClientRenameResponse, error) {
	var err error
	req, err := client.renameCreateRequest(ctx, renameSource, options, sourceLeaseAccessConditions, destinationLeaseAccessConditions, copyFileSMBInfo, shareFileHTTPHeaders)
	if err != nil {
		return FileClientRenameResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientRenameResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientRenameResponse{}, err
	}
	resp, err := client.renameHandleResponse(httpResp)
	return resp, err
}

// renameCreateRequest creates the Rename request.
func (client *FileClient) renameCreateRequest(ctx context.Context, renameSource string, options *FileClientRenameOptions, sourceLeaseAccessConditions *SourceLeaseAccessConditions, destinationLeaseAccessConditions *DestinationLeaseAccessConditions, copyFileSMBInfo *CopyFileSMBInfo, shareFileHTTPHeaders *ShareFileHTTPHeaders) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "rename")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	req.Raw().Header["x-ms-file-rename-source"] = []string{renameSource}
	if options != nil && options.ReplaceIfExists != nil {
		req.Raw().Header["x-ms-file-rename-replace-if-exists"] = []string{strconv.FormatBool(*options.ReplaceIfExists)}
	}
	if options != nil && options.IgnoreReadOnly != nil {
		req.Raw().Header["x-ms-file-rename-ignore-readonly"] = []string{strconv.FormatBool(*options.IgnoreReadOnly)}
	}
	if sourceLeaseAccessConditions != nil && sourceLeaseAccessConditions.SourceLeaseID != nil {
		req.Raw().Header["x-ms-source-lease-id"] = []string{*sourceLeaseAccessConditions.SourceLeaseID}
	}
	if destinationLeaseAccessConditions != nil && destinationLeaseAccessConditions.DestinationLeaseID != nil {
		req.Raw().Header["x-ms-destination-lease-id"] = []string{*destinationLeaseAccessConditions.DestinationLeaseID}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FileAttributes != nil {
		req.Raw().Header["x-ms-file-attributes"] = []string{*copyFileSMBInfo.FileAttributes}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FileCreationTime != nil {
		req.Raw().Header["x-ms-file-creation-time"] = []string{*copyFileSMBInfo.FileCreationTime}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FileLastWriteTime != nil {
		req.Raw().Header["x-ms-file-last-write-time"] = []string{*copyFileSMBInfo.FileLastWriteTime}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FileChangeTime != nil {
		req.Raw().Header["x-ms-file-change-time"] = []string{*copyFileSMBInfo.FileChangeTime}
	}
	if options != nil && options.FilePermission != nil {
		req.Raw().Header["x-ms-file-permission"] = []string{*options.FilePermission}
	}
	if options != nil && options.FilePermissionFormat != nil {
		req.Raw().Header["x-ms-file-permission-format"] = []string{string(*options.FilePermissionFormat)}
	}
	if options != nil && options.FilePermissionKey != nil {
		req.Raw().Header["x-ms-file-permission-key"] = []string{*options.FilePermissionKey}
	}
	if options != nil && options.Metadata != nil {
		for k, v := range options.Metadata {
			if v != nil {
				req.Raw().Header["x-ms-meta-"+k] = []string{*v}
			}
		}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentType != nil {
		req.Raw().Header["x-ms-content-type"] = []string{*shareFileHTTPHeaders.ContentType}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.allowSourceTrailingDot != nil {
		req.Raw().Header["x-ms-source-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowSourceTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// renameHandleResponse handles the Rename response.
func (client *FileClient) renameHandleResponse(resp *http.Response) (FileClientRenameResponse, error) {
	result := FileClientRenameResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientRenameResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-attributes"); val != "" {
		result.FileAttributes = &val
	}
	if val := resp.Header.Get("x-ms-file-change-time"); val != "" {
		fileChangeTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientRenameResponse{}, err
		}
		result.FileChangeTime = &fileChangeTime
	}
	if val := resp.Header.Get("x-ms-file-creation-time"); val != "" {
		fileCreationTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientRenameResponse{}, err
		}
		result.FileCreationTime = &fileCreationTime
	}
	if val := resp.Header.Get("x-ms-file-id"); val != "" {
		result.ID = &val
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientRenameResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-file-parent-id"); val != "" {
		result.ParentID = &val
	}
	if val := resp.Header.Get("x-ms-file-permission-key"); val != "" {
		result.FilePermissionKey = &val
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return FileClientRenameResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientRenameResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// SetHTTPHeaders - Sets HTTP headers on the file.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientSetHTTPHeadersOptions contains the optional parameters for the FileClient.SetHTTPHeaders method.
//   - ShareFileHTTPHeaders - ShareFileHTTPHeaders contains a group of parameters for the FileClient.Create method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) SetHTTPHeaders(ctx context.Context, options *FileClientSetHTTPHeadersOptions, shareFileHTTPHeaders *ShareFileHTTPHeaders, leaseAccessConditions *LeaseAccessConditions) (FileClientSetHTTPHeadersResponse, error) {
	var err error
	req, err := client.setHTTPHeadersCreateRequest(ctx, options, shareFileHTTPHeaders, leaseAccessConditions)
	if err != nil {
		return FileClientSetHTTPHeadersResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientSetHTTPHeadersResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientSetHTTPHeadersResponse{}, err
	}
	resp, err := client.setHTTPHeadersHandleResponse(httpResp)
	return resp, err
}

// setHTTPHeadersCreateRequest creates the SetHTTPHeaders request.
func (client *FileClient) setHTTPHeadersCreateRequest(ctx context.Context, options *FileClientSetHTTPHeadersOptions, shareFileHTTPHeaders *ShareFileHTTPHeaders, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "properties")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.FileContentLength != nil {
		req.Raw().Header["x-ms-content-length"] = []string{strconv.FormatInt(*options.FileContentLength, 10)}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentType != nil {
		req.Raw().Header["x-ms-content-type"] = []string{*shareFileHTTPHeaders.ContentType}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentEncoding != nil {
		req.Raw().Header["x-ms-content-encoding"] = []string{*shareFileHTTPHeaders.ContentEncoding}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentLanguage != nil {
		req.Raw().Header["x-ms-content-language"] = []string{*shareFileHTTPHeaders.ContentLanguage}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.CacheControl != nil {
		req.Raw().Header["x-ms-cache-control"] = []string{*shareFileHTTPHeaders.CacheControl}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentMD5 != nil {
		req.Raw().Header["x-ms-content-md5"] = []string{base64.StdEncoding.EncodeToString(shareFileHTTPHeaders.ContentMD5)}
	}
	if shareFileHTTPHeaders != nil && shareFileHTTPHeaders.ContentDisposition != nil {
		req.Raw().Header["x-ms-content-disposition"] = []string{*shareFileHTTPHeaders.ContentDisposition}
	}
	if options != nil && options.FilePermission != nil {
		req.Raw().Header["x-ms-file-permission"] = []string{*options.FilePermission}
	}
	if options != nil && options.FilePermissionFormat != nil {
		req.Raw().Header["x-ms-file-permission-format"] = []string{string(*options.FilePermissionFormat)}
	}
	if options != nil && options.FilePermissionKey != nil {
		req.Raw().Header["x-ms-file-permission-key"] = []string{*options.FilePermissionKey}
	}
	if options != nil && options.FileAttributes != nil {
		req.Raw().Header["x-ms-file-attributes"] = []string{*options.FileAttributes}
	}
	if options != nil && options.FileCreationTime != nil {
		req.Raw().Header["x-ms-file-creation-time"] = []string{*options.FileCreationTime}
	}
	if options != nil && options.FileLastWriteTime != nil {
		req.Raw().Header["x-ms-file-last-write-time"] = []string{*options.FileLastWriteTime}
	}
	if options != nil && options.FileChangeTime != nil {
		req.Raw().Header["x-ms-file-change-time"] = []string{*options.FileChangeTime}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	if options != nil && options.Owner != nil {
		req.Raw().Header["x-ms-owner"] = []string{*options.Owner}
	}
	if options != nil && options.Group != nil {
		req.Raw().Header["x-ms-group"] = []string{*options.Group}
	}
	if options != nil && options.FileMode != nil {
		req.Raw().Header["x-ms-mode"] = []string{*options.FileMode}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// setHTTPHeadersHandleResponse handles the SetHTTPHeaders response.
func (client *FileClient) setHTTPHeadersHandleResponse(resp *http.Response) (FileClientSetHTTPHeadersResponse, error) {
	result := FileClientSetHTTPHeadersResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientSetHTTPHeadersResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-attributes"); val != "" {
		result.FileAttributes = &val
	}
	if val := resp.Header.Get("x-ms-file-change-time"); val != "" {
		fileChangeTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientSetHTTPHeadersResponse{}, err
		}
		result.FileChangeTime = &fileChangeTime
	}
	if val := resp.Header.Get("x-ms-file-creation-time"); val != "" {
		fileCreationTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientSetHTTPHeadersResponse{}, err
		}
		result.FileCreationTime = &fileCreationTime
	}
	if val := resp.Header.Get("x-ms-file-id"); val != "" {
		result.ID = &val
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientSetHTTPHeadersResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-mode"); val != "" {
		result.FileMode = &val
	}
	if val := resp.Header.Get("x-ms-file-parent-id"); val != "" {
		result.ParentID = &val
	}
	if val := resp.Header.Get("x-ms-file-permission-key"); val != "" {
		result.FilePermissionKey = &val
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.Group = &val
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return FileClientSetHTTPHeadersResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientSetHTTPHeadersResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-link-count"); val != "" {
		linkCount, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return FileClientSetHTTPHeadersResponse{}, err
		}
		result.LinkCount = &linkCount
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.Owner = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// SetMetadata - Updates user-defined metadata for the specified file.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - options - FileClientSetMetadataOptions contains the optional parameters for the FileClient.SetMetadata method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) SetMetadata(ctx context.Context, options *FileClientSetMetadataOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientSetMetadataResponse, error) {
	var err error
	req, err := client.setMetadataCreateRequest(ctx, options, leaseAccessConditions)
	if err != nil {
		return FileClientSetMetadataResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientSetMetadataResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return FileClientSetMetadataResponse{}, err
	}
	resp, err := client.setMetadataHandleResponse(httpResp)
	return resp, err
}

// setMetadataCreateRequest creates the SetMetadata request.
func (client *FileClient) setMetadataCreateRequest(ctx context.Context, options *FileClientSetMetadataOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "metadata")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.Metadata != nil {
		for k, v := range options.Metadata {
			if v != nil {
				req.Raw().Header["x-ms-meta-"+k] = []string{*v}
			}
		}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// setMetadataHandleResponse handles the SetMetadata response.
func (client *FileClient) setMetadataHandleResponse(resp *http.Response) (FileClientSetMetadataResponse, error) {
	result := FileClientSetMetadataResponse{}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientSetMetadataResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return FileClientSetMetadataResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientSetMetadataResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// StartCopy - Copies a blob or file to a destination file within the storage account.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - copySource - Specifies the URL of the source file or blob, up to 2 KB in length. To copy a file to another file within
//     the same storage account, you may use Shared Key to authenticate the source file. If you are
//     copying a file from another storage account, or if you are copying a blob from the same storage account or another storage
//     account, then you must authenticate the source file or blob using a shared
//     access signature. If the source is a public blob, no authentication is required to perform the copy operation. A file in
//     a share snapshot can also be specified as a copy source.
//   - options - FileClientStartCopyOptions contains the optional parameters for the FileClient.StartCopy method.
//   - CopyFileSMBInfo - CopyFileSMBInfo contains a group of parameters for the DirectoryClient.Rename method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) StartCopy(ctx context.Context, copySource string, options *FileClientStartCopyOptions, copyFileSMBInfo *CopyFileSMBInfo, leaseAccessConditions *LeaseAccessConditions) (FileClientStartCopyResponse, error) {
	var err error
	req, err := client.startCopyCreateRequest(ctx, copySource, options, copyFileSMBInfo, leaseAccessConditions)
	if err != nil {
		return FileClientStartCopyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientStartCopyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return FileClientStartCopyResponse{}, err
	}
	resp, err := client.startCopyHandleResponse(httpResp)
	return resp, err
}

// startCopyCreateRequest creates the StartCopy request.
func (client *FileClient) startCopyCreateRequest(ctx context.Context, copySource string, options *FileClientStartCopyOptions, copyFileSMBInfo *CopyFileSMBInfo, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if options != nil && options.Metadata != nil {
		for k, v := range options.Metadata {
			if v != nil {
				req.Raw().Header["x-ms-meta-"+k] = []string{*v}
			}
		}
	}
	req.Raw().Header["x-ms-copy-source"] = []string{copySource}
	if options != nil && options.FilePermission != nil {
		req.Raw().Header["x-ms-file-permission"] = []string{*options.FilePermission}
	}
	if options != nil && options.FilePermissionFormat != nil {
		req.Raw().Header["x-ms-file-permission-format"] = []string{string(*options.FilePermissionFormat)}
	}
	if options != nil && options.FilePermissionKey != nil {
		req.Raw().Header["x-ms-file-permission-key"] = []string{*options.FilePermissionKey}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FilePermissionCopyMode != nil {
		req.Raw().Header["x-ms-file-permission-copy-mode"] = []string{string(*copyFileSMBInfo.FilePermissionCopyMode)}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.IgnoreReadOnly != nil {
		req.Raw().Header["x-ms-file-copy-ignore-readonly"] = []string{strconv.FormatBool(*copyFileSMBInfo.IgnoreReadOnly)}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FileAttributes != nil {
		req.Raw().Header["x-ms-file-attributes"] = []string{*copyFileSMBInfo.FileAttributes}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FileCreationTime != nil {
		req.Raw().Header["x-ms-file-creation-time"] = []string{*copyFileSMBInfo.FileCreationTime}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FileLastWriteTime != nil {
		req.Raw().Header["x-ms-file-last-write-time"] = []string{*copyFileSMBInfo.FileLastWriteTime}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.FileChangeTime != nil {
		req.Raw().Header["x-ms-file-change-time"] = []string{*copyFileSMBInfo.FileChangeTime}
	}
	if copyFileSMBInfo != nil && copyFileSMBInfo.SetArchiveAttribute != nil {
		req.Raw().Header["x-ms-file-copy-set-archive"] = []string{strconv.FormatBool(*copyFileSMBInfo.SetArchiveAttribute)}
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.allowSourceTrailingDot != nil {
		req.Raw().Header["x-ms-source-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowSourceTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	if options != nil && options.Owner != nil {
		req.Raw().Header["x-ms-owner"] = []string{*options.Owner}
	}
	if options != nil && options.Group != nil {
		req.Raw().Header["x-ms-group"] = []string{*options.Group}
	}
	if options != nil && options.FileMode != nil {
		req.Raw().Header["x-ms-mode"] = []string{*options.FileMode}
	}
	if options != nil && options.FileModeCopyMode != nil {
		req.Raw().Header["x-ms-file-mode-copy-mode"] = []string{string(*options.FileModeCopyMode)}
	}
	if options != nil && options.FileOwnerCopyMode != nil {
		req.Raw().Header["x-ms-file-owner-copy-mode"] = []string{string(*options.FileOwnerCopyMode)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// startCopyHandleResponse handles the StartCopy response.
func (client *FileClient) startCopyHandleResponse(resp *http.Response) (FileClientStartCopyResponse, error) {
	result := FileClientStartCopyResponse{}
	if val := resp.Header.Get("x-ms-copy-id"); val != "" {
		result.CopyID = &val
	}
	if val := resp.Header.Get("x-ms-copy-status"); val != "" {
		result.CopyStatus = (*CopyStatusType)(&val)
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientStartCopyResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientStartCopyResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// UploadRange - Upload a range of bytes to a file.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - rangeParam - Specifies the range of bytes to be written. Both the start and end of the range must be specified. For an
//     update operation, the range can be up to 4 MB in size. For a clear operation, the range can be
//     up to the value of the file's full size. The File service accepts only a single byte range for the Range and 'x-ms-range'
//     headers, and the byte range must be specified in the following format:
//     bytes=startByte-endByte.
//   - fileRangeWrite - Specify one of the following options: - Update: Writes the bytes specified by the request body into the
//     specified range. The Range and Content-Length headers must match to perform the update. - Clear:
//     Clears the specified range and releases the space used in storage for that range. To clear a range, set the Content-Length
//     header to zero, and set the Range header to a value that indicates the range
//     to clear, up to maximum file size.
//   - contentLength - Specifies the number of bytes being transmitted in the request body. When the x-ms-write header is set
//     to clear, the value of this header must be set to zero.
//   - optionalbody - Initial data.
//   - options - FileClientUploadRangeOptions contains the optional parameters for the FileClient.UploadRange method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) UploadRange(ctx context.Context, rangeParam string, fileRangeWrite FileRangeWriteType, contentLength int64, optionalbody io.ReadSeekCloser, options *FileClientUploadRangeOptions, leaseAccessConditions *LeaseAccessConditions) (FileClientUploadRangeResponse, error) {
	var err error
	req, err := client.uploadRangeCreateRequest(ctx, rangeParam, fileRangeWrite, contentLength, optionalbody, options, leaseAccessConditions)
	if err != nil {
		return FileClientUploadRangeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientUploadRangeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FileClientUploadRangeResponse{}, err
	}
	resp, err := client.uploadRangeHandleResponse(httpResp)
	return resp, err
}

// uploadRangeCreateRequest creates the UploadRange request.
func (client *FileClient) uploadRangeCreateRequest(ctx context.Context, rangeParam string, fileRangeWrite FileRangeWriteType, contentLength int64, optionalbody io.ReadSeekCloser, options *FileClientUploadRangeOptions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "range")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-range"] = []string{rangeParam}
	req.Raw().Header["x-ms-write"] = []string{string(fileRangeWrite)}
	req.Raw().Header["Content-Length"] = []string{strconv.FormatInt(contentLength, 10)}
	if options != nil && options.ContentMD5 != nil {
		req.Raw().Header["Content-MD5"] = []string{base64.StdEncoding.EncodeToString(options.ContentMD5)}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.FileLastWrittenMode != nil {
		req.Raw().Header["x-ms-file-last-write-time"] = []string{string(*options.FileLastWrittenMode)}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	if options != nil && options.StructuredBodyType != nil {
		req.Raw().Header["x-ms-structured-body"] = []string{*options.StructuredBodyType}
	}
	if options != nil && options.StructuredContentLength != nil {
		req.Raw().Header["x-ms-structured-content-length"] = []string{strconv.FormatInt(*options.StructuredContentLength, 10)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	if err := req.SetBody(optionalbody, "application/octet-stream"); err != nil {
		return nil, err
	}
	return req, nil
}

// uploadRangeHandleResponse handles the UploadRange response.
func (client *FileClient) uploadRangeHandleResponse(resp *http.Response) (FileClientUploadRangeResponse, error) {
	result := FileClientUploadRangeResponse{}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return FileClientUploadRangeResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientUploadRangeResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientUploadRangeResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return FileClientUploadRangeResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientUploadRangeResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-structured-body"); val != "" {
		result.StructuredBodyType = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// UploadRangeFromURL - Upload a range of bytes to a file where the contents are read from a URL.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-05-05
//   - rangeParam - Writes data to the specified byte range in the file.
//   - copySource - Specifies the URL of the source file or blob, up to 2 KB in length. To copy a file to another file within
//     the same storage account, you may use Shared Key to authenticate the source file. If you are
//     copying a file from another storage account, or if you are copying a blob from the same storage account or another storage
//     account, then you must authenticate the source file or blob using a shared
//     access signature. If the source is a public blob, no authentication is required to perform the copy operation. A file in
//     a share snapshot can also be specified as a copy source.
//   - contentLength - Specifies the number of bytes being transmitted in the request body. When the x-ms-write header is set
//     to clear, the value of this header must be set to zero.
//   - options - FileClientUploadRangeFromURLOptions contains the optional parameters for the FileClient.UploadRangeFromURL method.
//   - SourceModifiedAccessConditions - SourceModifiedAccessConditions contains a group of parameters for the FileClient.UploadRangeFromURL
//     method.
//   - LeaseAccessConditions - LeaseAccessConditions contains a group of parameters for the ShareClient.GetProperties method.
func (client *FileClient) UploadRangeFromURL(ctx context.Context, rangeParam string, copySource string, contentLength int64, options *FileClientUploadRangeFromURLOptions, sourceModifiedAccessConditions *SourceModifiedAccessConditions, leaseAccessConditions *LeaseAccessConditions) (FileClientUploadRangeFromURLResponse, error) {
	var err error
	req, err := client.uploadRangeFromURLCreateRequest(ctx, rangeParam, copySource, contentLength, options, sourceModifiedAccessConditions, leaseAccessConditions)
	if err != nil {
		return FileClientUploadRangeFromURLResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return FileClientUploadRangeFromURLResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return FileClientUploadRangeFromURLResponse{}, err
	}
	resp, err := client.uploadRangeFromURLHandleResponse(httpResp)
	return resp, err
}

// uploadRangeFromURLCreateRequest creates the UploadRangeFromURL request.
func (client *FileClient) uploadRangeFromURLCreateRequest(ctx context.Context, rangeParam string, copySource string, contentLength int64, options *FileClientUploadRangeFromURLOptions, sourceModifiedAccessConditions *SourceModifiedAccessConditions, leaseAccessConditions *LeaseAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.endpoint)
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("comp", "range")
	if options != nil && options.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*options.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["x-ms-range"] = []string{rangeParam}
	req.Raw().Header["x-ms-copy-source"] = []string{copySource}
	if options != nil && options.SourceRange != nil {
		req.Raw().Header["x-ms-source-range"] = []string{*options.SourceRange}
	}
	req.Raw().Header["x-ms-write"] = []string{"update"}
	req.Raw().Header["Content-Length"] = []string{strconv.FormatInt(contentLength, 10)}
	if options != nil && options.SourceContentCRC64 != nil {
		req.Raw().Header["x-ms-source-content-crc64"] = []string{base64.StdEncoding.EncodeToString(options.SourceContentCRC64)}
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfMatchCRC64 != nil {
		req.Raw().Header["x-ms-source-if-match-crc64"] = []string{base64.StdEncoding.EncodeToString(sourceModifiedAccessConditions.SourceIfMatchCRC64)}
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfNoneMatchCRC64 != nil {
		req.Raw().Header["x-ms-source-if-none-match-crc64"] = []string{base64.StdEncoding.EncodeToString(sourceModifiedAccessConditions.SourceIfNoneMatchCRC64)}
	}
	req.Raw().Header["x-ms-version"] = []string{"2025-05-05"}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header["x-ms-lease-id"] = []string{*leaseAccessConditions.LeaseID}
	}
	if options != nil && options.CopySourceAuthorization != nil {
		req.Raw().Header["x-ms-copy-source-authorization"] = []string{*options.CopySourceAuthorization}
	}
	if options != nil && options.FileLastWrittenMode != nil {
		req.Raw().Header["x-ms-file-last-write-time"] = []string{string(*options.FileLastWrittenMode)}
	}
	if client.allowTrailingDot != nil {
		req.Raw().Header["x-ms-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowTrailingDot)}
	}
	if client.allowSourceTrailingDot != nil {
		req.Raw().Header["x-ms-source-allow-trailing-dot"] = []string{strconv.FormatBool(*client.allowSourceTrailingDot)}
	}
	if client.fileRequestIntent != nil {
		req.Raw().Header["x-ms-file-request-intent"] = []string{string(*client.fileRequestIntent)}
	}
	req.Raw().Header["Accept"] = []string{"application/xml"}
	return req, nil
}

// uploadRangeFromURLHandleResponse handles the UploadRangeFromURL response.
func (client *FileClient) uploadRangeFromURLHandleResponse(resp *http.Response) (FileClientUploadRangeFromURLResponse, error) {
	result := FileClientUploadRangeFromURLResponse{}
	if val := resp.Header.Get("Content-MD5"); val != "" {
		contentMD5, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return FileClientUploadRangeFromURLResponse{}, err
		}
		result.ContentMD5 = contentMD5
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientUploadRangeFromURLResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = (*azcore.ETag)(&val)
	}
	if val := resp.Header.Get("x-ms-file-last-write-time"); val != "" {
		fileLastWriteTime, err := time.Parse(ISO8601, val)
		if err != nil {
			return FileClientUploadRangeFromURLResponse{}, err
		}
		result.FileLastWriteTime = &fileLastWriteTime
	}
	if val := resp.Header.Get("x-ms-request-server-encrypted"); val != "" {
		isServerEncrypted, err := strconv.ParseBool(val)
		if err != nil {
			return FileClientUploadRangeFromURLResponse{}, err
		}
		result.IsServerEncrypted = &isServerEncrypted
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return FileClientUploadRangeFromURLResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("x-ms-content-crc64"); val != "" {
		xMSContentCRC64, err := base64.StdEncoding.DecodeString(val)
		if err != nil {
			return FileClientUploadRangeFromURLResponse{}, err
		}
		result.XMSContentCRC64 = xMSContentCRC64
	}
	return result, nil
}
