// components/services/font/public/mojom/font_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/font/public/mojom/font_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace font_service::mojom {
class TypefaceStyleDataView;

class FontIdentityDataView;

class FontRenderStyleDataView;



}  // font_service::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::font_service::mojom::TypefaceStyleDataView> {
  using Data = ::font_service::mojom::internal::TypefaceStyle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_service::mojom::FontIdentityDataView> {
  using Data = ::font_service::mojom::internal::FontIdentity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::font_service::mojom::FontRenderStyleDataView> {
  using Data = ::font_service::mojom::internal::FontRenderStyle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace font_service::mojom {


enum class TypefaceSlant : int32_t {
  
  ROMAN = 0,
  
  ITALIC = 1,
  
  OBLIQUE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TypefaceSlant value);
inline bool IsKnownEnumValue(TypefaceSlant value) {
  return internal::TypefaceSlant_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RenderStyleSwitch : int32_t {
  
  OFF = 0,
  
  ON = 1,
  
  NO_PREFERENCE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RenderStyleSwitch value);
inline bool IsKnownEnumValue(RenderStyleSwitch value) {
  return internal::RenderStyleSwitch_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FontServiceInterfaceBase {};

using FontServicePtrDataView =
    mojo::InterfacePtrDataView<FontServiceInterfaceBase>;
using FontServiceRequestDataView =
    mojo::InterfaceRequestDataView<FontServiceInterfaceBase>;
using FontServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FontServiceInterfaceBase>;
using FontServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FontServiceInterfaceBase>;


class TypefaceStyleDataView {
 public:
  TypefaceStyleDataView() = default;

  TypefaceStyleDataView(
      internal::TypefaceStyle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t weight() const {
    return data_->weight;
  }
  uint8_t width() const {
    return data_->width;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSlant(UserType* output) const {
    auto data_value = data_->slant;
    return mojo::internal::Deserialize<::font_service::mojom::TypefaceSlant>(
        data_value, output);
  }
  TypefaceSlant slant() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::TypefaceSlant>(data_->slant));
  }
 private:
  internal::TypefaceStyle_Data* data_ = nullptr;
};


class FontIdentityDataView {
 public:
  FontIdentityDataView() = default;

  FontIdentityDataView(
      internal::FontIdentity_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t id() const {
    return data_->id;
  }
  int32_t ttc_index() const {
    return data_->ttc_index;
  }
  inline void GetFilepathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilepath(UserType* output) {
    
    auto* pointer = data_->filepath.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::FontIdentity_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FontRenderStyleDataView {
 public:
  FontRenderStyleDataView() = default;

  FontRenderStyleDataView(
      internal::FontRenderStyle_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadUseBitmaps(UserType* output) const {
    auto data_value = data_->use_bitmaps;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_bitmaps() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_bitmaps));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseAutohint(UserType* output) const {
    auto data_value = data_->use_autohint;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_autohint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_autohint));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseHinting(UserType* output) const {
    auto data_value = data_->use_hinting;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_hinting() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_hinting));
  }
  uint8_t hint_style() const {
    return data_->hint_style;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseAntialias(UserType* output) const {
    auto data_value = data_->use_antialias;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_antialias() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_antialias));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseSubpixelRendering(UserType* output) const {
    auto data_value = data_->use_subpixel_rendering;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_subpixel_rendering() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_subpixel_rendering));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseSubpixelPositioning(UserType* output) const {
    auto data_value = data_->use_subpixel_positioning;
    return mojo::internal::Deserialize<::font_service::mojom::RenderStyleSwitch>(
        data_value, output);
  }
  RenderStyleSwitch use_subpixel_positioning() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::font_service::mojom::RenderStyleSwitch>(data_->use_subpixel_positioning));
  }
 private:
  internal::FontRenderStyle_Data* data_ = nullptr;
};


}  // font_service::mojom

namespace std {

template <>
struct hash<::font_service::mojom::TypefaceSlant>
    : public mojo::internal::EnumHashImpl<::font_service::mojom::TypefaceSlant> {};

template <>
struct hash<::font_service::mojom::RenderStyleSwitch>
    : public mojo::internal::EnumHashImpl<::font_service::mojom::RenderStyleSwitch> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_service::mojom::TypefaceSlant, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::font_service::mojom::TypefaceSlant, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::font_service::mojom::TypefaceSlant>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_service::mojom::RenderStyleSwitch, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::font_service::mojom::RenderStyleSwitch, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::font_service::mojom::RenderStyleSwitch>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_service::mojom::TypefaceStyleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::font_service::mojom::TypefaceStyleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::font_service::mojom::internal::TypefaceStyle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->weight = Traits::weight(input);
    fragment->width = Traits::width(input);
    mojo::internal::Serialize<::font_service::mojom::TypefaceSlant>(
        Traits::slant(input), &fragment->slant);
  }

  static bool Deserialize(::font_service::mojom::internal::TypefaceStyle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::font_service::mojom::TypefaceStyleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_service::mojom::FontIdentityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::font_service::mojom::FontIdentityDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::font_service::mojom::internal::FontIdentity_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
    fragment->ttc_index = Traits::ttc_index(input);
    decltype(Traits::filepath(input)) in_filepath = Traits::filepath(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filepath)::BaseType> filepath_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_filepath, filepath_fragment);
    fragment->filepath.Set(
        filepath_fragment.is_null() ? nullptr : filepath_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->filepath.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filepath in FontIdentity struct");
  }

  static bool Deserialize(::font_service::mojom::internal::FontIdentity_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::font_service::mojom::FontIdentityDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::font_service::mojom::FontRenderStyleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::font_service::mojom::FontRenderStyleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::font_service::mojom::internal::FontRenderStyle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::font_service::mojom::RenderStyleSwitch>(
        Traits::use_bitmaps(input), &fragment->use_bitmaps);
    mojo::internal::Serialize<::font_service::mojom::RenderStyleSwitch>(
        Traits::use_autohint(input), &fragment->use_autohint);
    mojo::internal::Serialize<::font_service::mojom::RenderStyleSwitch>(
        Traits::use_hinting(input), &fragment->use_hinting);
    fragment->hint_style = Traits::hint_style(input);
    mojo::internal::Serialize<::font_service::mojom::RenderStyleSwitch>(
        Traits::use_antialias(input), &fragment->use_antialias);
    mojo::internal::Serialize<::font_service::mojom::RenderStyleSwitch>(
        Traits::use_subpixel_rendering(input), &fragment->use_subpixel_rendering);
    mojo::internal::Serialize<::font_service::mojom::RenderStyleSwitch>(
        Traits::use_subpixel_positioning(input), &fragment->use_subpixel_positioning);
  }

  static bool Deserialize(::font_service::mojom::internal::FontRenderStyle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::font_service::mojom::FontRenderStyleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace font_service::mojom {



inline void FontIdentityDataView::GetFilepathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->filepath.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}





}  // font_service::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::font_service::mojom::TypefaceSlant> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::font_service::mojom::TypefaceSlant value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::font_service::mojom::RenderStyleSwitch> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::font_service::mojom::RenderStyleSwitch value);
};

} // namespace perfetto

#endif  // COMPONENTS_SERVICES_FONT_PUBLIC_MOJOM_FONT_SERVICE_MOJOM_SHARED_H_