// components/schema_org/common/metadata.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace schema_org::mojom {
namespace internal {
class Property_Data;
class Entity_Data;
class Values_Data;

#pragma pack(push, 1)


class  Values_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  Values_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~Values_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<Values_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class Values_Tag : uint32_t {

    
    kBoolValues,
    
    kLongValues,
    
    kStringValues,
    
    kEntityValues,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<mojo::internal::Array_Data<bool>> f_bool_values;
    mojo::internal::Pointer<mojo::internal::Array_Data<int64_t>> f_long_values;
    mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> f_string_values;
    mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Entity_Data>>> f_entity_values;
    uint64_t unknown;
  };

  uint32_t size;
  Values_Tag tag;
  Union_ data;
};
static_assert(sizeof(Values_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(Values_Data)");
class  Property_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  internal::Values_Data values;

 private:
  friend class mojo::internal::MessageFragment<Property_Data>;

  Property_Data();
  ~Property_Data() = delete;
};
static_assert(sizeof(Property_Data) == 32,
              "Bad sizeof(Property_Data)");
// Used by Property::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Property_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Property_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Property_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Property_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Property_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Entity_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> type;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Property_Data>>> properties;

 private:
  friend class mojo::internal::MessageFragment<Entity_Data>;

  Entity_Data();
  ~Entity_Data() = delete;
};
static_assert(sizeof(Entity_Data) == 24,
              "Bad sizeof(Entity_Data)");
// Used by Entity::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Entity_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Entity_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Entity_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Entity_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Entity_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // schema_org::mojom

#endif  // COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_SHARED_INTERNAL_H_