/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.arnx.jsonic.io.InputSource;

public class ReaderInputSource
implements InputSource {
    long lines = 1L;
    long columns = 1L;
    long offset = 0L;
    final Reader reader;
    final char[] buf = new char[256];
    int start = 0;
    int end = 0;

    public ReaderInputSource(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.reader = new InputStreamReader(inputStream, this.determineEncoding(inputStream));
    }

    public ReaderInputSource(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.reader = reader;
    }

    public int next() throws IOException {
        int n;
        if (this.start == this.end) {
            n = this.reader.read(this.buf, this.start, Math.min(this.buf.length - this.start, this.buf.length / 2));
            if (n != -1) {
                this.end = (this.end + n) % this.buf.length;
            } else {
                return -1;
            }
        }
        if ((n = this.buf[this.start]) == 13 || n == 10 && this.buf[(this.start + this.buf.length - 1) % this.buf.length] != '\r') {
            ++this.lines;
            this.columns = 0L;
        } else {
            ++this.columns;
        }
        ++this.offset;
        this.start = (this.start + 1) % this.buf.length;
        return n;
    }

    public void back() {
        --this.offset;
        --this.columns;
        this.start = (this.start + this.buf.length - 1) % this.buf.length;
    }

    public long getLineNumber() {
        return this.lines;
    }

    public long getColumnNumber() {
        return this.columns;
    }

    public long getOffset() {
        return this.offset;
    }

    String determineEncoding(InputStream inputStream) throws IOException {
        String string = "UTF-8";
        inputStream.mark(4);
        byte[] byArray = new byte[4];
        int n = inputStream.read(byArray);
        if (n == 2) {
            if ((byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) != 0 || (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
                string = "UTF-16BE";
            } else if ((byArray[0] & 0xFF) != 0 && (byArray[1] & 0xFF) == 0 || (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
                string = "UTF-16LE";
            }
        } else if (n == 4) {
            if ((byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) == 0) {
                string = "UTF-32BE";
            } else if ((byArray[2] & 0xFF) == 0 && (byArray[3] & 0xFF) == 0) {
                string = "UTF-32LE";
            } else if ((byArray[0] & 0xFF) == 0 && (byArray[1] & 0xFF) != 0 || (byArray[0] & 0xFF) == 254 && (byArray[1] & 0xFF) == 255) {
                string = "UTF-16BE";
            } else if ((byArray[0] & 0xFF) != 0 && (byArray[1] & 0xFF) == 0 || (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 254) {
                string = "UTF-16LE";
            }
        }
        inputStream.reset();
        return string;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n = this.columns - 1L < (long)this.buf.length ? (int)this.columns - 1 : this.buf.length - 1; i >= 0; --i) {
            stringBuffer.append(this.buf[(this.start - 2 + this.buf.length - i) % (this.buf.length - 1)]);
        }
        return stringBuffer.toString();
    }
}

