/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;
import oracle.sql.RAW;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class RawCommonAccessor
extends Accessor {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    RawCommonAccessor(OracleStatement _statement, int _representationMaxLength, boolean forBind) {
        super(Representation.RAW, _statement, _representationMaxLength, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$11, null, _statement, _representationMaxLength, forBind);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void init(OracleStatement oracleStatement, int n2, int n3, int n4, short s2, int n5) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void max_len;
            void external_type;
            void form;
            void database_type;
            void internal_type;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$0, this, oracleStatement, n2, n3, n4, s2, n5);
            }
            this.init((OracleStatement)stmt, (int)internal_type, (int)database_type, (short)form, false);
            this.initForDataAccess((int)external_type, (int)max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void init(OracleStatement oracleStatement, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, long l2, int n8, short s2) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void total_elems;
            void contflag;
            void scale;
            void precision;
            void flags;
            void nullable;
            int max_len;
            void form;
            void database_type;
            void internal_type;
            void stmt;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$1, this, oracleStatement, n2, n3, n4, bl, n5, n6, n7, l2, n8, s2);
            }
            this.init((OracleStatement)stmt, (int)internal_type, (int)database_type, (short)form, false);
            this.initForDescribe((int)internal_type, max_len, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)total_elems, (short)form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            byte[] b_array;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if ((b_array = this.getBytes((int)currentRow)) == null) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$2, this, string);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$2, this, null);
                }
                return null;
            }
            int len = b_array.length;
            if (len == 0) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$2, this, string);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$2, this, null);
                }
                return null;
            }
            String string = RepConversion.bArray2String(b_array);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$2, this, string);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$2, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            byte[] b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$3, this, n2);
            }
            if ((b2 = this.getBytes((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$3, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            PhysicalConnection conn = this.statement.connection;
            InputStream inputStream = conn.conversion.ConvertStream(new ByteArrayInputStream(b2), 2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$3, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$3, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getUnicodeStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            byte[] b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$4, this, n2);
            }
            if ((b2 = this.getBytes((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$4, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$4, this, null);
                }
                return null;
            }
            PhysicalConnection conn = this.statement.connection;
            InputStream inputStream = conn.conversion.ConvertStream(new ByteArrayInputStream(b2), 3);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$4, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$4, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            byte[] b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$5, this, n2);
            }
            if ((b2 = this.getBytes((int)currentRow)) == null) {
                Reader reader = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$5, this, reader);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            int rlen = b2.length;
            char[] charBuf = new char[rlen << 1];
            int chars_read = DBConversion.RAWBytesToHexChars(b2, rlen, charBuf);
            CharArrayReader charArrayReader = new CharArrayReader(charBuf, 0, chars_read);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$5, this, charArrayReader);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$5, this, null);
            }
            return charArrayReader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            byte[] b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$6, this, n2);
            }
            if ((b2 = this.getBytes((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$6, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$6, this, null);
                }
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(b2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$6, this, byteArrayInputStream);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$6, this, null);
            }
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$7, this, n2);
            }
            byte[] byArray = this.getBytes((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$7, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$7, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$8, this, n2, map);
            }
            byte[] byArray = this.getBytes((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$8, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$8, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$9, this, n2);
            }
            RAW rAW = this.getRAW((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$9, this, rAW);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$9, this, null);
            }
            return rAW;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    RAW getRAW(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            byte[] b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if ((b2 = this.getBytes((int)currentRow)) == null) {
                RAW rAW = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$10, this, rAW);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            RAW rAW = new RAW(b2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$10, this, rAW);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$10, this, null);
            }
            return rAW;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, RawCommonAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$11 = RawCommonAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = RawCommonAccessor.class.getDeclaredMethod("getRAW", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = RawCommonAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = RawCommonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = RawCommonAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = RawCommonAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = RawCommonAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = RawCommonAccessor.class.getDeclaredMethod("getUnicodeStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = RawCommonAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = RawCommonAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = RawCommonAccessor.class.getDeclaredMethod("init", OracleStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = RawCommonAccessor.class.getDeclaredMethod("init", OracleStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

