/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.BoundBuiltinCallable;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;

public final class PDecoratedMethod
extends PythonBuiltinObject
implements BoundBuiltinCallable<Object> {
    private Object callable;

    public PDecoratedMethod(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    public PDecoratedMethod(Object cls, Shape instanceShape, Object callable) {
        this(cls, instanceShape);
        this.callable = callable;
    }

    public Object getCallable() {
        return this.callable;
    }

    public void setCallable(Object callable) {
        assert (this.callable == null);
        this.callable = callable;
    }

    @Override
    public Object boundToObject(PythonBuiltinClassType binding, PythonLanguage language) {
        if (GetClassNode.GetPythonObjectClassNode.executeUncached(this) != PythonBuiltinClassType.PStaticmethod) {
            if (this.callable instanceof BoundBuiltinCallable) {
                return PFactory.createBuiltinClassmethodFromCallableObj(language, ((BoundBuiltinCallable)this.callable).boundToObject(binding, language));
            }
        } else if (this.callable instanceof PBuiltinMethod) {
            return PFactory.createStaticmethodFromCallableObj(language, ((PBuiltinMethod)this.callable).getBuiltinFunction().boundToObject(binding, language));
        }
        return this;
    }

    public String getName() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }

    public Signature getSignature() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }
}

