/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.gss;

import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.gss.GSSCallbackHandler;
import com.amazon.redshift.gss.GssAction;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.io.IOException;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;

public class MakeGSS {
    public static void authenticate(RedshiftStream pgStream, String host, String user, String password, String jaasApplicationName, String kerberosServerName, boolean useSpnego, boolean jaasLogin, boolean logServerErrorDetail, RedshiftLogger logger) throws IOException, SQLException {
        Exception result;
        if (RedshiftLogger.isEnable()) {
            logger.log(LogLevel.DEBUG, " <=BE AuthenticationReqGSS", new Object[0]);
        }
        if (jaasApplicationName == null) {
            jaasApplicationName = "rsjdbc";
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            Set<GSSCredential> gssCreds;
            boolean performAuthentication = jaasLogin;
            GSSCredential gssCredential = null;
            Subject sub = Subject.getSubject(AccessController.getContext());
            if (sub != null && (gssCreds = sub.getPrivateCredentials(GSSCredential.class)) != null && !gssCreds.isEmpty()) {
                gssCredential = gssCreds.iterator().next();
                performAuthentication = false;
            }
            if (performAuthentication) {
                LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
                lc.login();
                sub = lc.getSubject();
            }
            GssAction action = new GssAction(pgStream, gssCredential, host, user, kerberosServerName, useSpnego, logServerErrorDetail, logger);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new RedshiftException(GT.tr("GSS Authentication failed", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        if (result != null) {
            throw new RedshiftException(GT.tr("GSS Authentication failed", new Object[0]), RedshiftState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

