/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltins;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyNumberAddNode;
import com.oracle.graal.python.lib.PyNumberAndNode;
import com.oracle.graal.python.lib.PyNumberDivmodNode;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyNumberFloorDivideNode;
import com.oracle.graal.python.lib.PyNumberInPlaceAddNode;
import com.oracle.graal.python.lib.PyNumberInPlaceAndNode;
import com.oracle.graal.python.lib.PyNumberInPlaceFloorDivideNode;
import com.oracle.graal.python.lib.PyNumberInPlaceLshiftNode;
import com.oracle.graal.python.lib.PyNumberInPlaceMatrixMultiplyNode;
import com.oracle.graal.python.lib.PyNumberInPlaceMultiplyNode;
import com.oracle.graal.python.lib.PyNumberInPlaceOrNode;
import com.oracle.graal.python.lib.PyNumberInPlacePowerNode;
import com.oracle.graal.python.lib.PyNumberInPlaceRemainderNode;
import com.oracle.graal.python.lib.PyNumberInPlaceRshiftNode;
import com.oracle.graal.python.lib.PyNumberInPlaceSubtractNode;
import com.oracle.graal.python.lib.PyNumberInPlaceTrueDivideNode;
import com.oracle.graal.python.lib.PyNumberInPlaceXorNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyNumberLongNode;
import com.oracle.graal.python.lib.PyNumberLshiftNode;
import com.oracle.graal.python.lib.PyNumberMatrixMultiplyNode;
import com.oracle.graal.python.lib.PyNumberMultiplyNode;
import com.oracle.graal.python.lib.PyNumberOrNode;
import com.oracle.graal.python.lib.PyNumberPowerNode;
import com.oracle.graal.python.lib.PyNumberRemainderNode;
import com.oracle.graal.python.lib.PyNumberRshiftNode;
import com.oracle.graal.python.lib.PyNumberSubtractNode;
import com.oracle.graal.python.lib.PyNumberTrueDivideNode;
import com.oracle.graal.python.lib.PyNumberXorNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.lib.PySequenceConcatNode;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.lib.PySequenceDelItemNode;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.lib.PySequenceInPlaceConcatNode;
import com.oracle.graal.python.lib.PySequenceInPlaceRepeatNode;
import com.oracle.graal.python.lib.PySequenceIterSearchNode;
import com.oracle.graal.python.lib.PySequenceSetItemNode;
import com.oracle.graal.python.lib.PySequenceSizeNode;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextAbstractBuiltins {
    private static PList getKeys(VirtualFrame frame, Node inliningTarget, Object obj, PyObjectGetAttr getAttrNode, CallNode callNode, ListNodes.ConstructListNode listNode) {
        Object attr = getAttrNode.execute((Frame)frame, inliningTarget, obj, SpecialMethodNames.T_KEYS);
        return listNode.execute((Frame)frame, callNode.execute((Frame)frame, attr, new Object[0]));
    }

    static abstract class PyObject_SetDoc
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyObject_SetDoc.class);

        PyObject_SetDoc() {
        }

        @Specialization
        static int set(PBuiltinFunction obj, Object value, @Cached.Shared(value="write") @Cached WriteAttributeToPythonObjectNode write) {
            write.execute(obj, SpecialAttributeNames.T___DOC__, value);
            return 1;
        }

        @Specialization
        static int set(PBuiltinMethod obj, Object value, @Cached.Shared(value="write") @Cached WriteAttributeToPythonObjectNode write) {
            PyObject_SetDoc.set(obj.getBuiltinFunction(), value, write);
            return 1;
        }

        @Specialization
        static int set(GetSetDescriptor obj, Object value, @Cached.Shared(value="write") @Cached WriteAttributeToPythonObjectNode write) {
            write.execute(obj, SpecialAttributeNames.T___DOC__, value);
            return 1;
        }

        @Specialization(guards={"isType.execute(inliningTarget, type)"}, limit="1")
        static int set(PythonAbstractNativeObject type, Object value, @Bind Node inliningTarget, @Cached TypeNodes.IsTypeNode isType, @Cached TruffleString.SwitchEncodingNode switchEncoding, @Cached CStructAccess.WritePointerNode writePointerNode) {
            Object cValue;
            if (value instanceof TruffleString) {
                TruffleString stringValue = (TruffleString)value;
                cValue = new CArrayWrappers.CStringWrapper(switchEncoding.execute((AbstractTruffleString)stringValue, TruffleString.Encoding.UTF_8), TruffleString.Encoding.UTF_8);
            } else {
                cValue = PythonContext.get(inliningTarget).getNativeNull();
            }
            writePointerNode.write(type.getPtr(), CFields.PyTypeObject__tp_doc, cValue);
            return 1;
        }

        @Fallback
        static int set(Object obj, Object value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            LOGGER.warning("Unexpected type in PyObject_SetDoc: " + String.valueOf(obj.getClass()));
            return 1;
        }
    }

    static abstract class PyObject_GetDoc
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyObject_GetDoc() {
        }

        @Specialization
        Object get(Object obj, @Bind Node inliningTarget, @Cached PyObjectLookupAttr lookupAttr, @Cached CExtNodes.AsCharPointerNode asCharPointerNode) {
            try {
                Object doc = lookupAttr.execute(null, inliningTarget, obj, SpecialAttributeNames.T___DOC__);
                if (!(doc instanceof PNone)) {
                    return asCharPointerNode.execute(doc);
                }
            }
            catch (PException pException) {
                // empty catch block
            }
            return this.getNULL();
        }
    }

    static abstract class GraalPyPrivate_Iter_Send
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Iter_Send() {
        }

        @Specialization
        Object send(Object iter, Object arg, @Bind Node inliningTarget, @Cached PyIterCheckNode pyiterCheck, @Cached PyObjectCallMethodObjArgs callMethodNode, @Cached PyIterNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isClassProfile) {
            if (arg instanceof PNone && pyiterCheck.execute(inliningTarget, iter)) {
                try {
                    return nextNode.execute(null, inliningTarget, iter);
                }
                catch (IteratorExhausted e) {
                    return this.getNativeNull();
                }
            }
            try {
                return callMethodNode.execute(null, inliningTarget, iter, BuiltinNames.T_SEND, arg);
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, isClassProfile);
                return this.getNativeNull();
            }
        }
    }

    static abstract class PyIter_Next
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyIter_Next() {
        }

        @Specialization
        Object check(Object object, @Bind Node inliningTarget, @Cached PyIterNextNode nextNode) {
            try {
                return nextNode.execute(null, inliningTarget, object);
            }
            catch (IteratorExhausted e) {
                return this.getNativeNull();
            }
        }
    }

    static abstract class GraalPyPrivate_Mapping_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Mapping_Size() {
        }

        @Specialization
        static int doMapping(Object obj, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode, @Cached TypeNodes.IsSameTypeNode isSameType, @Cached GetClassNode getClassNode, @Cached PRaiseNode raiseNode) {
            Object cls = getClassNode.execute(inliningTarget, obj);
            if (isSameType.execute(inliningTarget, cls, (Object)PythonBuiltinClassType.PSet) || isSameType.execute(inliningTarget, cls, (Object)PythonBuiltinClassType.PFrozenSet) || isSameType.execute(inliningTarget, cls, (Object)PythonBuiltinClassType.PDeque)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_ISNT_MAPPING, obj);
            }
            return sizeNode.execute(null, inliningTarget, obj);
        }
    }

    static abstract class PyMapping_Values
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMapping_Values() {
        }

        @Specialization
        static Object values(PDict obj, @Cached.Shared @Cached ListNodes.ConstructListNode listNode, @Cached DictBuiltins.ValuesNode valuesNode) {
            return listNode.execute(null, valuesNode.execute(null, obj));
        }

        @Specialization(guards={"!isDict(obj)"})
        static Object values(Object obj, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CallNode callNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode, @Cached PRaiseNode raiseNode) {
            PyMapping_Values.checkNonNullArg(inliningTarget, obj, raiseNode);
            Object attr = getAttrNode.execute(inliningTarget, obj, SpecialMethodNames.T_VALUES);
            return listNode.execute(null, callNode.executeWithoutFrame(attr, new Object[0]));
        }
    }

    static abstract class PyMapping_Items
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMapping_Items() {
        }

        @Specialization
        static Object items(PDict obj, @Cached DictBuiltins.ItemsNode itemsNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode) {
            return listNode.execute(null, itemsNode.execute(null, obj));
        }

        @Specialization(guards={"!isDict(obj)"})
        static Object items(Object obj, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CallNode callNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode) {
            Object attr = getAttrNode.execute(inliningTarget, obj, SpecialMethodNames.T_ITEMS);
            return listNode.execute(null, callNode.executeWithoutFrame(attr, new Object[0]));
        }
    }

    static abstract class PyMapping_Keys
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyMapping_Keys() {
        }

        @Specialization
        Object keys(PDict obj, @Cached DictBuiltins.KeysNode keysNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode) {
            return listNode.execute(null, keysNode.execute(null, obj));
        }

        @Specialization(guards={"!isDict(obj)"})
        Object keys(Object obj, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttrNode, @Cached CallNode callNode, @Cached.Shared @Cached ListNodes.ConstructListNode listNode) {
            return PythonCextAbstractBuiltins.getKeys(null, inliningTarget, obj, getAttrNode, callNode, listNode);
        }
    }

    static abstract class PyObject_LengthHint
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_LengthHint() {
        }

        @Specialization
        static long doGenericUnboxed(Object obj, long defaultValue, @Bind Node inliningTarget, @Cached IteratorNodes.GetLength getLength) {
            int len = getLength.execute(null, inliningTarget, obj);
            if (len == -1) {
                return defaultValue;
            }
            return len;
        }
    }

    static abstract class GraalPyPrivate_Object_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Object_Size() {
        }

        @Specialization
        static int doGenericUnboxed(Object obj, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            assert (!(obj instanceof PythonAbstractNativeObject));
            return sizeNode.execute(null, inliningTarget, obj);
        }
    }

    static abstract class PyObject_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyObject_GetItem() {
        }

        @Specialization
        Object doManaged(Object list, Object key, @Bind Node inliningTarget, @Cached PyObjectGetItem getItem) {
            return getItem.execute(null, inliningTarget, list, key);
        }
    }

    static abstract class PySequence_Index
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Index() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Bind Node inliningTarget, @Cached PySequenceIterSearchNode searchNode) {
            return searchNode.execute(inliningTarget, haystack, needle, 2);
        }
    }

    static abstract class PySequence_Count
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Count() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Bind Node inliningTarget, @Cached PySequenceIterSearchNode searchNode) {
            return searchNode.execute(inliningTarget, haystack, needle, 1);
        }
    }

    static abstract class PySequence_DelSlice
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PySequence_DelSlice() {
        }

        @Specialization
        static int setSlice(Object sequence, Object iLow, Object iHigh, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached TpSlotMpAssSubscript.CallSlotMpAssSubscriptNode callSetItem, @Cached PySliceNew sliceNode, @Cached PRaiseNode raiseNode) {
            TpSlots slots = getSlotsNode.execute(inliningTarget, sequence);
            if (slots.mp_ass_subscript() != null) {
                PSlice slice = sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE);
                callSetItem.execute(null, inliningTarget, slots.mp_ass_subscript(), sequence, slice, PNone.NO_VALUE);
                return 0;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.P_OBJECT_DOESNT_SUPPORT_SLICE_DELETION, sequence);
        }
    }

    static abstract class PySequence_SetSlice
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PySequence_SetSlice() {
        }

        @Specialization
        static int setSlice(Object sequence, Object iLow, Object iHigh, Object s, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached TpSlotMpAssSubscript.CallSlotMpAssSubscriptNode callSetItem, @Cached PySliceNew sliceNode, @Cached PRaiseNode raiseNode) {
            TpSlots slots = getSlotsNode.execute(inliningTarget, sequence);
            if (slots.mp_ass_subscript() != null) {
                PSlice slice = sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE);
                callSetItem.execute(null, inliningTarget, slots.mp_ass_subscript(), sequence, slice, s);
                return 0;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.P_OBJECT_DOESNT_SUPPORT_SLICE_ASSIGNMENT, sequence);
        }
    }

    static abstract class GraalPyPrivate_Sequence_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Sequence_Size() {
        }

        @Specialization
        static int doSequence(Object obj, @Bind Node inliningTarget, @Cached PySequenceSizeNode sizeNode) {
            return sizeNode.execute(null, inliningTarget, obj);
        }
    }

    static abstract class GraalPyPrivate_Sequence_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Sequence_GetItem() {
        }

        @Specialization
        static Object doManaged(Object delegate, long position, @Bind Node inliningTarget, @Cached PySequenceGetItemNode getItemNode) {
            if ((long)((int)position) != position) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, position);
            }
            return getItemNode.execute(null, delegate, (int)position);
        }
    }

    static abstract class GraalPyPrivate_Sequence_DelItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Sequence_DelItem() {
        }

        @Specialization
        static Object run(Object o, long i, @Bind Node inliningTarget, @Cached PySequenceDelItemNode delItemNode) {
            if ((long)((int)i) != i) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, i);
            }
            delItemNode.execute(null, inliningTarget, o, (int)i);
            return 0;
        }
    }

    static abstract class PySequence_InPlaceConcat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_InPlaceConcat() {
        }

        @Specialization
        static Object concat(Object s1, Object s2, @Bind Node inliningTarget, @Cached PySequenceInPlaceConcatNode concat) {
            return concat.execute(null, inliningTarget, s1, s2);
        }
    }

    static abstract class PySequence_Concat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Concat() {
        }

        @Specialization
        Object doIt(Object s1, Object s2, @Bind Node inliningTarget, @Cached PySequenceConcatNode pySeqConcat) {
            return pySeqConcat.execute(null, inliningTarget, s1, s2);
        }
    }

    static abstract class PySequence_InPlaceRepeat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_InPlaceRepeat() {
        }

        @Specialization
        static Object repeat(Object obj, long n, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached PySequenceInPlaceRepeatNode repeat) {
            if (!PInt.isIntRange(n)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            return repeat.execute(null, inliningTarget, obj, (int)n);
        }
    }

    static abstract class PySequence_Contains
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySequence_Contains() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Bind Node inliningTarget, @Cached PySequenceContainsNode containsNode) {
            return PInt.intValue(containsNode.execute(null, inliningTarget, haystack, needle));
        }
    }

    static abstract class PySequence_GetSlice
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PySequence_GetSlice() {
        }

        @Specialization(guards={"checkNode.execute(inliningTarget, obj)"}, limit="1")
        static Object getSlice(Object obj, long iLow, long iHigh, @Bind Node inliningTarget, @Cached.Exclusive @Cached PySequenceCheckNode checkNode, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PySliceNew sliceNode, @Cached CallNode callNode) {
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, obj, SpecialMethodNames.T___GETITEM__);
            return callNode.executeWithoutFrame(getItemCallable, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE));
        }

        @Specialization(guards={"!checkNode.execute(inliningTarget, obj)"}, limit="1")
        static Object getSlice(Object obj, Object key, Object value, @Cached.Exclusive @Cached PySequenceCheckNode checkNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_IS_UNSLICEABLE, obj);
        }
    }

    public static abstract class GraalPyPrivate_Sequence_SetItem
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        @Specialization
        static Object setItem(Object obj, long key, Object value, @Bind Node inliningTarget, @Cached PySequenceSetItemNode setItemNode) {
            if ((long)((int)key) != key) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, key);
            }
            setItemNode.execute(null, inliningTarget, obj, (int)key, value);
            return 0;
        }
    }

    static abstract class PySequence_List
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySequence_List() {
        }

        @Specialization
        Object values(Object obj, @Cached ListNodes.ConstructListNode listNode) {
            return listNode.execute(null, obj);
        }
    }

    static abstract class PySequence_Tuple
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySequence_Tuple() {
        }

        @Specialization
        Object values(Object obj, @Bind Node inliningTarget, @Cached TupleBuiltins.TupleNode tupleNode, @Cached GetClassNode getClassNode) {
            if (getClassNode.execute(inliningTarget, obj) == PythonBuiltinClassType.PTuple) {
                return obj;
            }
            return tupleNode.execute(null, (Object)PythonBuiltinClassType.PTuple, obj);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Power
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        GraalPyPrivate_PyNumber_Power() {
        }

        @Specialization
        Object doGeneric(Object o1, Object o2, Object o3, @Cached PyNumberPowerNode powerNode) {
            return powerNode.execute(null, o1, o2, o3);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlacePower
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlacePower() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, Object o3, @Cached PyNumberInPlacePowerNode powerNode) {
            return powerNode.execute(null, o1, o2, o3);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceMatrixMultiply
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceMatrixMultiply() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceMatrixMultiplyNode matrixMultiplyNode) {
            return matrixMultiplyNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceRshift
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceRshift() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceRshiftNode rshiftNode) {
            return rshiftNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceLshift
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceLshift() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceLshiftNode lshiftNode) {
            return lshiftNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceXor
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceXor() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceXorNode xorNode) {
            return xorNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceOr
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceOr() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceOrNode orNode) {
            return orNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceAnd
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceAnd() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceAndNode andNode) {
            return andNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceFloorDivide
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceFloorDivide() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceFloorDivideNode floorDivideNode) {
            return floorDivideNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceTrueDivide
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceTrueDivide() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceTrueDivideNode trueDivideNode) {
            return trueDivideNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceRemainder
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceRemainder() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceRemainderNode remainderNode) {
            return remainderNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceMultiply
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceMultiply() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceMultiplyNode multiplyNode) {
            return multiplyNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceSubtract
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceSubtract() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceSubtractNode subtractNode) {
            return subtractNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_InPlaceAdd
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_InPlaceAdd() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberInPlaceAddNode addNode) {
            return addNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_MatrixMultiply
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_MatrixMultiply() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberMatrixMultiplyNode matrixMultiplyNode) {
            return matrixMultiplyNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Rshift
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Rshift() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberRshiftNode rshiftNode) {
            return rshiftNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Lshift
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Lshift() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberLshiftNode lshiftNode) {
            return lshiftNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Xor
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Xor() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberXorNode xorNode) {
            return xorNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Or
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Or() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberOrNode orNode) {
            return orNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_And
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_And() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberAndNode andNode) {
            return andNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Divmod
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Divmod() {
        }

        @Specialization
        static Object div(Object a, Object b, @Bind Node inliningTarget, @Cached PyNumberDivmodNode divmodNode) {
            return divmodNode.execute(null, inliningTarget, a, b);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_FloorDivide
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_FloorDivide() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberFloorDivideNode floorDivideNode) {
            return floorDivideNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_TrueDivide
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_TrueDivide() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberTrueDivideNode trueDivideNode) {
            return trueDivideNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Remainder
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Remainder() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberRemainderNode remainderNode) {
            return remainderNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Multiply
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Multiply() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberMultiplyNode multiplyNode) {
            return multiplyNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Subtract
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Subtract() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberSubtractNode subtractNode) {
            return subtractNode.execute(null, o1, o2);
        }
    }

    static abstract class GraalPyPrivate_PyNumber_Add
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_PyNumber_Add() {
        }

        @Specialization
        static Object doGeneric(Object o1, Object o2, @Cached PyNumberAddNode addNode) {
            return addNode.execute(null, o1, o2);
        }
    }

    static abstract class PyNumber_Float
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyNumber_Float() {
        }

        @Specialization
        static double doDoubleNativeWrapper(double object) {
            return object;
        }

        @Specialization
        static double doLongNativeWrapper(long object) {
            return object;
        }

        @Specialization
        static Object doGeneric(Object object, @Bind Node inliningTarget, @Cached PyNumberFloatNode pyNumberFloat) {
            return pyNumberFloat.execute(inliningTarget, object);
        }
    }

    protected static abstract class PyNumber_ToBase
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        protected PyNumber_ToBase() {
        }

        @Specialization(guards={"base == 2"})
        static Object toBase2(Object n, int base, @Bind Node inliningTarget, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached BuiltinFunctions.BinNode binNode) {
            Object i = indexNode.execute(null, inliningTarget, n);
            return binNode.execute(null, i);
        }

        @Specialization(guards={"base == 8"})
        static Object toBase8(Object n, int base, @Cached BuiltinFunctions.OctNode octNode) {
            return octNode.execute(null, n);
        }

        @Specialization(guards={"base == 10"})
        static Object toBase10(Object n, int base, @Bind Node inliningTarget, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached StringBuiltins.StrNewNode strNode) {
            Object i = indexNode.execute(null, inliningTarget, n);
            if (i instanceof Boolean) {
                i = (Boolean)i != false ? 1 : 0;
            }
            return strNode.executeWith(i);
        }

        @Specialization(guards={"base == 16"})
        static Object toBase16(Object n, int base, @Bind Node inliningTarget, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached BuiltinFunctions.HexNode hexNode) {
            Object i = indexNode.execute(null, inliningTarget, n);
            return hexNode.execute(null, i);
        }

        @Specialization(guards={"!checkBase(base)"})
        static Object toBase(Object n, int base, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BASE_MUST_BE);
        }

        protected boolean checkBase(int base) {
            return base == 2 || base == 8 || base == 10 || base == 16;
        }
    }

    static abstract class PyNumber_Long
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyNumber_Long() {
        }

        @Specialization
        static Object nlong(Object object, @Bind Node inliningTarget, @Cached PyNumberLongNode pyNumberLongNode) {
            return pyNumberLongNode.execute(null, inliningTarget, object);
        }
    }

    static abstract class PyNumber_Index
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyNumber_Index() {
        }

        @Specialization
        static Object index(Object obj, @Bind Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached PRaiseNode raiseNode) {
            PyNumber_Index.checkNonNullArg(inliningTarget, obj, raiseNode);
            return indexNode.execute(null, inliningTarget, obj);
        }
    }
}

