/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.props.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.props.internal.StandardConnectionPropertyDefiner;
import org.firebirdsql.jaybird.props.internal.UnregisteredDpbDefiner;
import org.firebirdsql.jaybird.props.spi.ConnectionPropertyDefinerSpi;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class ConnectionPropertyRegistry {
    private final Map<String, ConnectionProperty> connectionPropertiesMap;

    ConnectionPropertyRegistry(Map<String, ConnectionProperty> connectionPropertiesMap) {
        this.connectionPropertiesMap = Collections.unmodifiableMap(new HashMap<String, ConnectionProperty>(connectionPropertiesMap));
    }

    public ConnectionProperty getByName(String name) {
        return this.connectionPropertiesMap.get(name);
    }

    public ConnectionProperty getOrUnknown(String name) {
        ConnectionProperty property = this.getByName(name);
        return property != null ? property : ConnectionProperty.unknown(name);
    }

    Collection<ConnectionProperty> getRegisteredProperties() {
        return new HashSet<ConnectionProperty>(this.connectionPropertiesMap.values());
    }

    Collection<String> getRegisteredNames() {
        return new HashSet<String>(this.connectionPropertiesMap.keySet());
    }

    public static ConnectionPropertyRegistry getInstance() {
        return Holder.INSTANCE;
    }

    private static ConnectionPropertyRegistry loadProperties() {
        ConnectionPropertiesBuilder builder = new ConnectionPropertiesBuilder();
        ConnectionPropertyRegistry.getDefiners().forEach(definer -> definer.defineProperties().forEach(property -> builder.tryRegisterProperty((ConnectionProperty)property, (ConnectionPropertyDefinerSpi)definer)));
        UnregisteredDpbDefiner unregisteredDpbDefiner = new UnregisteredDpbDefiner(Collections.unmodifiableSet(builder.connectionPropertiesMap.keySet()));
        unregisteredDpbDefiner.defineProperties().forEach(property -> builder.tryRegisterProperty((ConnectionProperty)property, unregisteredDpbDefiner));
        return builder.build();
    }

    private static Stream<ConnectionPropertyDefinerSpi> getDefiners() {
        return Stream.concat(ConnectionPropertyRegistry.getStandardDefiners(), ConnectionPropertyRegistry.getCustomDefiners());
    }

    private static Stream<ConnectionPropertyDefinerSpi> getStandardDefiners() {
        return Stream.of(new StandardConnectionPropertyDefiner());
    }

    private static Stream<ConnectionPropertyDefinerSpi> getCustomDefiners() {
        try {
            ServiceLoader<ConnectionPropertyDefinerSpi> serviceLoader = ServiceLoader.load(ConnectionPropertyDefinerSpi.class, ConnectionPropertyRegistry.class.getClassLoader());
            ArrayList<ConnectionPropertyDefinerSpi> customDefiners = new ArrayList<ConnectionPropertyDefinerSpi>();
            Iterator<ConnectionPropertyDefinerSpi> iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                try {
                    customDefiners.add(iterator.next());
                }
                catch (RuntimeException | ServiceConfigurationError e) {
                    LoggerFactory.getLogger(ConnectionPropertyRegistry.class).warn("Could not load a custom ConnectionPropertyDefinerSpi", e);
                }
            }
            return customDefiners.stream();
        }
        catch (RuntimeException | ServiceConfigurationError e) {
            LoggerFactory.getLogger(ConnectionPropertyRegistry.class).warn("Could not load any custom ConnectionPropertyDefinerSpi", e);
            return Stream.empty();
        }
    }

    static /* synthetic */ ConnectionPropertyRegistry access$000() {
        return ConnectionPropertyRegistry.loadProperties();
    }

    static final class ConnectionPropertiesBuilder {
        private final Logger log = LoggerFactory.getLogger(ConnectionPropertiesBuilder.class);
        private final Map<String, ConnectionProperty> connectionPropertiesMap = new HashMap<String, ConnectionProperty>();
        private final Set<Integer> dpbItems = new HashSet<Integer>();
        private final Set<Integer> spbItems = new HashSet<Integer>();

        ConnectionPropertiesBuilder() {
        }

        void tryRegisterProperty(ConnectionProperty property, ConnectionPropertyDefinerSpi definer) {
            if (this.shouldRegisterProperty(property, definer)) {
                Stream.concat(Stream.of(property.name()), property.aliases().stream()).forEach(propertyNameOrAlias -> this.connectionPropertiesMap.put((String)propertyNameOrAlias, property));
                this.dpbItems.add(property.dpbItem());
                this.spbItems.add(property.spbItem());
            }
        }

        ConnectionPropertyRegistry build() {
            return new ConnectionPropertyRegistry(this.connectionPropertiesMap);
        }

        private boolean shouldRegisterProperty(ConnectionProperty property, ConnectionPropertyDefinerSpi definer) {
            block7: {
                block6: {
                    ConnectionProperty existingProperty = this.connectionPropertiesMap.get(property.name());
                    if (existingProperty != null && property.isIdenticalTo(existingProperty)) {
                        return false;
                    }
                    if (existingProperty != null) break block6;
                    if (!property.aliases().stream().anyMatch(this.connectionPropertiesMap::containsKey)) break block7;
                }
                this.handleDuplicateNameOrAlias(property, definer);
                return false;
            }
            if (property.hasDpbItem() && this.dpbItems.contains(property.dpbItem())) {
                this.handleDuplicateDpbItem(property, definer);
                return false;
            }
            if (property.hasSpbItem() && this.spbItems.contains(property.spbItem())) {
                this.handleDuplicateSpbItem(property, definer);
                return false;
            }
            return true;
        }

        private void handleDuplicateNameOrAlias(ConnectionProperty property, ConnectionPropertyDefinerSpi definer) {
            assert (!(definer instanceof StandardConnectionPropertyDefiner)) : "standard properties should not have duplicate aliases";
            HashSet<String> duplicateAliases = new HashSet<String>(property.aliases());
            duplicateAliases.add(property.name());
            duplicateAliases.retainAll(this.connectionPropertiesMap.keySet());
            this.log.warnf("Failed to register connection property, one or more of its aliases were already defined; duplicate alias(es): %s, connection property: %s", (Object)duplicateAliases, (Object)property);
            this.notifyNotRegistered(definer, property);
        }

        private void handleDuplicateDpbItem(ConnectionProperty property, ConnectionPropertyDefinerSpi definer) {
            this.handleDuplicateParameterBufferItem(property, definer, "DPB");
        }

        private void handleDuplicateSpbItem(ConnectionProperty property, ConnectionPropertyDefinerSpi definer) {
            this.handleDuplicateParameterBufferItem(property, definer, "SPB");
        }

        private void handleDuplicateParameterBufferItem(ConnectionProperty property, ConnectionPropertyDefinerSpi definer, String type) {
            assert (!(definer instanceof StandardConnectionPropertyDefiner)) : "standard properties should not have duplicate " + type + " items: " + property.name();
            this.log.warnf("Failed to register connection property, its %s item was already defined; connection property: %s", (Object)type, (Object)property);
            this.notifyNotRegistered(definer, property);
        }

        private void notifyNotRegistered(ConnectionPropertyDefinerSpi definer, ConnectionProperty connectionProperty) {
            try {
                definer.notRegistered(connectionProperty);
            }
            catch (Exception e) {
                this.log.warnfe("Exception received notifying definer.notRegistered(%s) at %s", connectionProperty, definer, e);
            }
        }
    }

    private static final class Holder {
        private static final ConnectionPropertyRegistry INSTANCE = ConnectionPropertyRegistry.access$000();

        private Holder() {
        }
    }
}

