'''OpenGL extension AMD.texture_gather_bias_lod

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.texture_gather_bias_lod to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension was developed based on existing built-in texture gather functions to allow
	implementations supporting bias of implicit level of detail and explicit control of level of
	detail in texture gather operations.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/texture_gather_bias_lod.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.texture_gather_bias_lod import *
from OpenGL.raw.GL.AMD.texture_gather_bias_lod import _EXTENSION_NAME

def glInitTextureGatherBiasLodAMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION