# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Union, Optional
from typing_extensions import Literal, Annotated, TypeAlias

from ..._utils import PropertyInfo
from ..._models import BaseModel

__all__ = [
    "ResponseFunctionShellToolCallOutput",
    "Output",
    "OutputOutcome",
    "OutputOutcomeTimeout",
    "OutputOutcomeExit",
]


class OutputOutcomeTimeout(BaseModel):
    """Indicates that the shell call exceeded its configured time limit."""

    type: Literal["timeout"]
    """The outcome type. Always `timeout`."""


class OutputOutcomeExit(BaseModel):
    """Indicates that the shell commands finished and returned an exit code."""

    exit_code: int
    """Exit code from the shell process."""

    type: Literal["exit"]
    """The outcome type. Always `exit`."""


OutputOutcome: TypeAlias = Annotated[Union[OutputOutcomeTimeout, OutputOutcomeExit], PropertyInfo(discriminator="type")]


class Output(BaseModel):
    """The content of a shell tool call output that was emitted."""

    outcome: OutputOutcome
    """
    Represents either an exit outcome (with an exit code) or a timeout outcome for a
    shell call output chunk.
    """

    stderr: str
    """The standard error output that was captured."""

    stdout: str
    """The standard output that was captured."""

    created_by: Optional[str] = None
    """The identifier of the actor that created the item."""


class ResponseFunctionShellToolCallOutput(BaseModel):
    """The output of a shell tool call that was emitted."""

    id: str
    """The unique ID of the shell call output.

    Populated when this item is returned via API.
    """

    call_id: str
    """The unique ID of the shell tool call generated by the model."""

    max_output_length: Optional[int] = None
    """The maximum length of the shell command output.

    This is generated by the model and should be passed back with the raw output.
    """

    output: List[Output]
    """An array of shell call output contents"""

    status: Literal["in_progress", "completed", "incomplete"]
    """The status of the shell call output.

    One of `in_progress`, `completed`, or `incomplete`.
    """

    type: Literal["shell_call_output"]
    """The type of the shell call output. Always `shell_call_output`."""

    created_by: Optional[str] = None
    """The identifier of the actor that created the item."""
