# SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: BSD-2-Clause

from .abstract import *
from .common import Opaque
from .containers import *
from .function_type import *
from .functions import *
from .iterators import *
from .misc import *
from .npytypes import *
from .scalars import *

__all__ = [
    "b1",
    "bool",
    "bool_",
    "boolean",
    "byte",
    "c8",
    "c16",
    "char",
    "complex64",
    "complex128",
    "deferred_type",
    "double",
    "f4",
    "f8",
    "ffi",
    "ffi_forced_object",
    "float32",
    "float64",
    "i1",
    "i2",
    "i4",
    "i8",
    "int8",
    "int16",
    "int32",
    "int64",
    "int_",
    "intc",
    "intp",
    "long_",
    "longlong",
    "none",
    "optional",
    "short",
    "size_t",
    "ssize_t",
    "u1",
    "u2",
    "u4",
    "u8",
    "uchar",
    "uint",
    "uint8",
    "uint16",
    "uint32",
    "uint64",
    "uintc",
    "uintp",
    "ulong",
    "ulonglong",
    "ushort",
    "void",
]

# TODO: Final

pyobject: PyObject = ...
ffi_forced_object: Opaque = ...
ffi: Opaque = ...
none: NoneType = ...
ellipsis: EllipsisType = ...
Any: Phantom = ...
undefined: Undefined = ...
py2_string_type: Opaque = ...
unicode_type: UnicodeType = ...
string: UnicodeType = ...
unknown: Dummy = ...
npy_rng: NumPyRandomGeneratorType = ...
npy_bitgen: NumPyRandomBitGeneratorType = ...

_undef_var: UndefVar = ...

code_type: Opaque = ...
pyfunc_type: Opaque = ...

voidptr: RawPointer = ...

optional = Optional
deferred_type = DeferredType
slice2_type: SliceType = ...
slice3_type: SliceType = ...
void: NoneType = ...

boolean: Boolean = ...
bool_: Boolean = ...
bool: Boolean = ...  # numpy>=2

int8: Integer = ...
int16: Integer = ...
int32: Integer = ...
int64: Integer = ...
intp: Integer = ...
intc: Integer = ...
ssize_t: Integer = ...
char: Integer = ...
short: Integer = ...
int_: Integer = ...
long_: Integer = ...
longlong: Integer = ...

byte: Integer = ...
uint8: Integer = ...
uint16: Integer = ...
uint32: Integer = ...
uint64: Integer = ...
uintp: Integer = ...
uintc: Integer = ...
size_t: Integer = ...
uchar: Integer = ...
ushort: Integer = ...
uint: Integer = ...
ulong: Integer = ...
ulonglong: Integer = ...

float16: Float = ...
float32: Float = ...
float_ = float32
float64: Float = ...
double = float64

# TODO: make generic in the wrapped `Float` type
complex64: Complex = ...
complex128: Complex = ...

range_iter32_type: RangeIteratorType = ...
range_iter64_type: RangeIteratorType = ...
unsigned_range_iter64_type: RangeIteratorType = ...
range_state32_type: RangeType = ...
range_state64_type: RangeType = ...
unsigned_range_state64_type: RangeType = ...

signed_domain: frozenset[Integer] = ...
unsigned_domain: frozenset[Integer] = ...
integer_domain: frozenset[Integer] = ...
real_domain: frozenset[Float] = ...
complex_domain: frozenset[Complex] = ...
number_domain: frozenset[Integer | Float | Complex] = ...

np_float_ = float32
b1 = bool_
i1 = int8
i2 = int16
i4 = int32
i8 = int64
u1 = uint8
u2 = uint16
u4 = uint32
u8 = uint64
f2 = float16
f4 = float32
f8 = float64
c8 = complex64
c16 = complex128
