# Interface for submodule: VideoStream
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate


# Interface for class: VideoStream
from ._proxies import VideoStreamProxy as _VideoStreamProxy
class _VideoStreamTemplateGetter():
    def __getitem__(self, parameters) -> _VideoStreamTemplate:
        """Specify class type with:
            	[INSERT_TYPE_NAMES_HERE]
            :return: VideoStreamTemplate
            """
        ...


class _VideoStreamTemplate(_itkTemplate, metaclass=_VideoStreamTemplateGetter):
    """Interface for instantiating itk::VideoStream< INSERT_TYPE_NAMES_HERE >
        Create a new VideoStream Object (of default type):
            'itk.VideoStream.New(**kwargs)
        Supports type specification through dictionary access:
            'itk.VideoStream[INSERT_TYPE_NAMES_HERE].New(**kwargs)"""

    @staticmethod
    def New(**kwargs) -> _VideoStreamProxy:
        """Instantiate itk::VideoStream< INSERT_TYPE_NAMES_HERE >"""
        ...

VideoStream = _VideoStreamTemplate

