/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningLogicWarning;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningRule;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningRuleListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningTranslation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailAutomatedReasoningInvalidFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailAutomatedReasoningInvalidFinding> {
    private static final SdkField<GuardrailAutomatedReasoningTranslation> TRANSLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("translation").getter(GuardrailAutomatedReasoningInvalidFinding.getter(GuardrailAutomatedReasoningInvalidFinding::translation)).setter(GuardrailAutomatedReasoningInvalidFinding.setter(Builder::translation)).constructor(GuardrailAutomatedReasoningTranslation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()}).build();
    private static final SdkField<List<GuardrailAutomatedReasoningRule>> CONTRADICTING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contradictingRules").getter(GuardrailAutomatedReasoningInvalidFinding.getter(GuardrailAutomatedReasoningInvalidFinding::contradictingRules)).setter(GuardrailAutomatedReasoningInvalidFinding.setter(Builder::contradictingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contradictingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAutomatedReasoningRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<GuardrailAutomatedReasoningLogicWarning> LOGIC_WARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicWarning").getter(GuardrailAutomatedReasoningInvalidFinding.getter(GuardrailAutomatedReasoningInvalidFinding::logicWarning)).setter(GuardrailAutomatedReasoningInvalidFinding.setter(Builder::logicWarning)).constructor(GuardrailAutomatedReasoningLogicWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD, CONTRADICTING_RULES_FIELD, LOGIC_WARNING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailAutomatedReasoningInvalidFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GuardrailAutomatedReasoningTranslation translation;
    private final List<GuardrailAutomatedReasoningRule> contradictingRules;
    private final GuardrailAutomatedReasoningLogicWarning logicWarning;

    private GuardrailAutomatedReasoningInvalidFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.contradictingRules = builder.contradictingRules;
        this.logicWarning = builder.logicWarning;
    }

    public final GuardrailAutomatedReasoningTranslation translation() {
        return this.translation;
    }

    public final boolean hasContradictingRules() {
        return this.contradictingRules != null && !(this.contradictingRules instanceof SdkAutoConstructList);
    }

    public final List<GuardrailAutomatedReasoningRule> contradictingRules() {
        return this.contradictingRules;
    }

    public final GuardrailAutomatedReasoningLogicWarning logicWarning() {
        return this.logicWarning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.translation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContradictingRules() ? this.contradictingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logicWarning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningInvalidFinding)) {
            return false;
        }
        GuardrailAutomatedReasoningInvalidFinding other = (GuardrailAutomatedReasoningInvalidFinding)obj;
        return Objects.equals(this.translation(), other.translation()) && this.hasContradictingRules() == other.hasContradictingRules() && Objects.equals(this.contradictingRules(), other.contradictingRules()) && Objects.equals(this.logicWarning(), other.logicWarning());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailAutomatedReasoningInvalidFinding").add("Translation", (Object)this.translation()).add("ContradictingRules", this.hasContradictingRules() ? this.contradictingRules() : null).add("LogicWarning", (Object)this.logicWarning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "translation": {
                return Optional.ofNullable(clazz.cast(this.translation()));
            }
            case "contradictingRules": {
                return Optional.ofNullable(clazz.cast(this.contradictingRules()));
            }
            case "logicWarning": {
                return Optional.ofNullable(clazz.cast(this.logicWarning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("contradictingRules", CONTRADICTING_RULES_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningInvalidFinding, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningInvalidFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GuardrailAutomatedReasoningTranslation translation;
        private List<GuardrailAutomatedReasoningRule> contradictingRules = DefaultSdkAutoConstructList.getInstance();
        private GuardrailAutomatedReasoningLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningInvalidFinding model) {
            this.translation(model.translation);
            this.contradictingRules(model.contradictingRules);
            this.logicWarning(model.logicWarning);
        }

        public final GuardrailAutomatedReasoningTranslation.Builder getTranslation() {
            return this.translation != null ? this.translation.toBuilder() : null;
        }

        public final void setTranslation(GuardrailAutomatedReasoningTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(GuardrailAutomatedReasoningTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final List<GuardrailAutomatedReasoningRule.Builder> getContradictingRules() {
            List<GuardrailAutomatedReasoningRule.Builder> result = GuardrailAutomatedReasoningRuleListCopier.copyToBuilder(this.contradictingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContradictingRules(Collection<GuardrailAutomatedReasoningRule.BuilderImpl> contradictingRules) {
            this.contradictingRules = GuardrailAutomatedReasoningRuleListCopier.copyFromBuilder(contradictingRules);
        }

        @Override
        public final Builder contradictingRules(Collection<GuardrailAutomatedReasoningRule> contradictingRules) {
            this.contradictingRules = GuardrailAutomatedReasoningRuleListCopier.copy(contradictingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contradictingRules(GuardrailAutomatedReasoningRule ... contradictingRules) {
            this.contradictingRules(Arrays.asList(contradictingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contradictingRules(Consumer<GuardrailAutomatedReasoningRule.Builder> ... contradictingRules) {
            this.contradictingRules(Stream.of(contradictingRules).map(c -> (GuardrailAutomatedReasoningRule)((GuardrailAutomatedReasoningRule.Builder)GuardrailAutomatedReasoningRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final GuardrailAutomatedReasoningLogicWarning.Builder getLogicWarning() {
            return this.logicWarning != null ? this.logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(GuardrailAutomatedReasoningLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(GuardrailAutomatedReasoningLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        public GuardrailAutomatedReasoningInvalidFinding build() {
            return new GuardrailAutomatedReasoningInvalidFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailAutomatedReasoningInvalidFinding> {
        public Builder translation(GuardrailAutomatedReasoningTranslation var1);

        default public Builder translation(Consumer<GuardrailAutomatedReasoningTranslation.Builder> translation) {
            return this.translation((GuardrailAutomatedReasoningTranslation)((GuardrailAutomatedReasoningTranslation.Builder)GuardrailAutomatedReasoningTranslation.builder().applyMutation(translation)).build());
        }

        public Builder contradictingRules(Collection<GuardrailAutomatedReasoningRule> var1);

        public Builder contradictingRules(GuardrailAutomatedReasoningRule ... var1);

        public Builder contradictingRules(Consumer<GuardrailAutomatedReasoningRule.Builder> ... var1);

        public Builder logicWarning(GuardrailAutomatedReasoningLogicWarning var1);

        default public Builder logicWarning(Consumer<GuardrailAutomatedReasoningLogicWarning.Builder> logicWarning) {
            return this.logicWarning((GuardrailAutomatedReasoningLogicWarning)((GuardrailAutomatedReasoningLogicWarning.Builder)GuardrailAutomatedReasoningLogicWarning.builder().applyMutation(logicWarning)).build());
        }
    }
}

