/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotResultSetCopier;
import software.amazon.awssdk.services.ec2.model.DeleteSnapshotReturnCode;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterImageResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeregisterImageResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Return").getter(DeregisterImageResponse.getter(DeregisterImageResponse::returnValue)).setter(DeregisterImageResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return").unmarshallLocationName("return").build()}).build();
    private static final SdkField<List<DeleteSnapshotReturnCode>> DELETE_SNAPSHOT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeleteSnapshotResults").getter(DeregisterImageResponse.getter(DeregisterImageResponse::deleteSnapshotResults)).setter(DeregisterImageResponse.setter(Builder::deleteSnapshotResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteSnapshotResultSet").unmarshallLocationName("deleteSnapshotResultSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteSnapshotReturnCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD, DELETE_SNAPSHOT_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeregisterImageResponse.memberNameToFieldInitializer();
    private final Boolean returnValue;
    private final List<DeleteSnapshotReturnCode> deleteSnapshotResults;

    private DeregisterImageResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.deleteSnapshotResults = builder.deleteSnapshotResults;
    }

    public final Boolean returnValue() {
        return this.returnValue;
    }

    public final boolean hasDeleteSnapshotResults() {
        return this.deleteSnapshotResults != null && !(this.deleteSnapshotResults instanceof SdkAutoConstructList);
    }

    public final List<DeleteSnapshotReturnCode> deleteSnapshotResults() {
        return this.deleteSnapshotResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeleteSnapshotResults() ? this.deleteSnapshotResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterImageResponse)) {
            return false;
        }
        DeregisterImageResponse other = (DeregisterImageResponse)((Object)obj);
        return Objects.equals(this.returnValue(), other.returnValue()) && this.hasDeleteSnapshotResults() == other.hasDeleteSnapshotResults() && Objects.equals(this.deleteSnapshotResults(), other.deleteSnapshotResults());
    }

    public final String toString() {
        return ToString.builder((String)"DeregisterImageResponse").add("Return", (Object)this.returnValue()).add("DeleteSnapshotResults", this.hasDeleteSnapshotResults() ? this.deleteSnapshotResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Return": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
            case "DeleteSnapshotResults": {
                return Optional.ofNullable(clazz.cast(this.deleteSnapshotResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Return", RETURN_FIELD);
        map.put("DeleteSnapshotResultSet", DELETE_SNAPSHOT_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterImageResponse, T> g) {
        return obj -> g.apply((DeregisterImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean returnValue;
        private List<DeleteSnapshotReturnCode> deleteSnapshotResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterImageResponse model) {
            super(model);
            this.returnValue(model.returnValue);
            this.deleteSnapshotResults(model.deleteSnapshotResults);
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final List<DeleteSnapshotReturnCode.Builder> getDeleteSnapshotResults() {
            List<DeleteSnapshotReturnCode.Builder> result = DeleteSnapshotResultSetCopier.copyToBuilder(this.deleteSnapshotResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeleteSnapshotResults(Collection<DeleteSnapshotReturnCode.BuilderImpl> deleteSnapshotResults) {
            this.deleteSnapshotResults = DeleteSnapshotResultSetCopier.copyFromBuilder(deleteSnapshotResults);
        }

        @Override
        public final Builder deleteSnapshotResults(Collection<DeleteSnapshotReturnCode> deleteSnapshotResults) {
            this.deleteSnapshotResults = DeleteSnapshotResultSetCopier.copy(deleteSnapshotResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteSnapshotResults(DeleteSnapshotReturnCode ... deleteSnapshotResults) {
            this.deleteSnapshotResults(Arrays.asList(deleteSnapshotResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteSnapshotResults(Consumer<DeleteSnapshotReturnCode.Builder> ... deleteSnapshotResults) {
            this.deleteSnapshotResults(Stream.of(deleteSnapshotResults).map(c -> (DeleteSnapshotReturnCode)((DeleteSnapshotReturnCode.Builder)DeleteSnapshotReturnCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeregisterImageResponse build() {
            return new DeregisterImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeregisterImageResponse> {
        public Builder returnValue(Boolean var1);

        public Builder deleteSnapshotResults(Collection<DeleteSnapshotReturnCode> var1);

        public Builder deleteSnapshotResults(DeleteSnapshotReturnCode ... var1);

        public Builder deleteSnapshotResults(Consumer<DeleteSnapshotReturnCode.Builder> ... var1);
    }
}

