"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationServiceMockWithoutMDSMock = exports.notificationServiceMock = exports.mainStateMock = exports.coreServicesMock = void 0;
var _services = require("../../public/services");
var _constants = require("../../common/constants");
var _httpClientMock = _interopRequireDefault(require("./httpClientMock"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const coreServicesMock = exports.coreServicesMock = {
  uiSettings: {
    get: jest.fn()
  },
  chrome: {
    setBreadcrumbs: jest.fn()
  },
  notifications: {
    toasts: {
      addDanger: jest.fn().mockName('addDanger'),
      addSuccess: jest.fn().mockName('addSuccess'),
      addError: jest.fn().mockName('addError')
    }
  }
};
const dataSourceIdMock = 'mockDataSourceId'; // Provide a mock dataSourceId
const multiDataSourceEnabledMock = true; // Provide a mock value for multiDataSourceEnabled

const browserServicesMock = new _services.NotificationService(_httpClientMock.default, dataSourceIdMock, multiDataSourceEnabledMock);
const browserServicesMockWithNoDataSource = new _services.NotificationService(_httpClientMock.default);
const notificationServiceMock = exports.notificationServiceMock = {
  notificationService: browserServicesMock
};
const notificationServiceMockWithoutMDSMock = exports.notificationServiceMockWithoutMDSMock = {
  notificationService: browserServicesMockWithNoDataSource
};
const mainStateMock = exports.mainStateMock = {
  availableChannels: _constants.CHANNEL_TYPE,
  availableConfigTypes: ['slack', 'chime', 'webhook', 'email', 'sns', 'smtp_account', 'ses_account', 'email_group'],
  tooltipSupport: true
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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