#!/usr/bin/env python
import logging
import os

from alembic import command
from alembic.config import Config

from app.config import get_database_url  # pylint: disable=E0401

logger = logging.getLogger(__name__)

SERVER_PATH = os.path.dirname(__file__)
ALEMBIC_MIGRATIONS_PATH = os.path.join(SERVER_PATH, "alembic")

alembic_cfg = Config()
alembic_cfg.set_main_option('script_location', ALEMBIC_MIGRATIONS_PATH)
alembic_cfg.set_main_option('sqlalchemy.url', get_database_url())
command.upgrade(alembic_cfg, 'head')
