/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;

public final class SimpleEventCategoryDataset<R extends Comparable, C extends Comparable>
extends AbstractDataset
implements CategoryDataset,
ListEventListener<Comparable> {
    private final DatasetChangeEvent immutableChangeEvent = new DatasetChangeEvent((Object)this, (Dataset)this);
    protected EventList<R> rowKeys;
    protected EventList<C> columnKeys;
    private final FunctionList.Function<Context<R, C>, Number> valueMaker;
    private final Context context;

    public SimpleEventCategoryDataset(EventList<R> rowKeys, EventList<C> columnKeys, FunctionList.Function<Context<R, C>, Number> valueMaker) {
        this.rowKeys = rowKeys;
        this.columnKeys = columnKeys;
        this.valueMaker = valueMaker;
        this.context = new Context<R, C>(rowKeys, columnKeys);
        this.rowKeys.addListEventListener(this);
        this.columnKeys.addListEventListener(this);
    }

    public Comparable getRowKey(int row) {
        return (Comparable)this.rowKeys.get(row);
    }

    public int getRowIndex(Comparable key) {
        return this.rowKeys.indexOf(key);
    }

    public List getRowKeys() {
        return this.rowKeys;
    }

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public Comparable getColumnKey(int column) {
        return (Comparable)this.columnKeys.get(column);
    }

    public int getColumnIndex(Comparable key) {
        return this.columnKeys.indexOf(key);
    }

    public List getColumnKeys() {
        return this.columnKeys;
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Number getValue(Comparable rowKey, Comparable columnKey) {
        this.context.update(rowKey, columnKey);
        return this.valueMaker.evaluate(this.context);
    }

    public Number getValue(int row, int column) {
        this.context.update(row, column);
        return this.valueMaker.evaluate(this.context);
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(this.immutableChangeEvent);
    }

    @Override
    public void listChanged(ListEvent<Comparable> listChanges) {
        this.fireDatasetChanged();
    }

    public void dispose() {
        this.rowKeys.removeListEventListener(this);
        this.columnKeys.removeListEventListener(this);
    }

    public static final class Context<R, C> {
        private final EventList<R> rowKeys;
        private final EventList<C> columnKeys;
        private int rowIndex;
        private int columnIndex;
        private R rowKey;
        private C columnKey;

        public Context(EventList<R> rowKeys, EventList<C> columnKeys) {
            this.rowKeys = rowKeys;
            this.columnKeys = columnKeys;
        }

        private void update(int rowIndex, int columnIndex) {
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
            this.rowKey = null;
            this.columnKey = null;
        }

        private void update(R rowKey, C columnKey) {
            this.rowIndex = -1;
            this.columnIndex = -1;
            this.rowKey = rowKey;
            this.columnKey = columnKey;
        }

        public EventList<R> getRowKeys() {
            return this.rowKeys;
        }

        public EventList<C> getColumnKeys() {
            return this.columnKeys;
        }

        public int getRowIndex() {
            if (this.rowIndex == -1) {
                this.rowIndex = this.rowKeys.indexOf(this.rowKey);
            }
            return this.rowIndex;
        }

        public int getColumnIndex() {
            if (this.columnIndex == -1) {
                this.columnIndex = this.columnKeys.indexOf(this.columnKey);
            }
            return this.columnIndex;
        }

        public R getRowKey() {
            if (this.rowKey == null) {
                this.rowKey = this.rowKeys.get(this.rowIndex);
            }
            return this.rowKey;
        }

        public C getColumnKey() {
            if (this.columnKey == null) {
                this.columnKey = this.columnKeys.get(this.columnIndex);
            }
            return this.columnKey;
        }
    }
}

