/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.TakeOfflineConfigurationBuilder;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.notification.SiteStatusListener;

@ThreadSafe
@Listener(observation=Listener.Observation.POST, sync=false)
public class OfflineStatus
implements CacheEventFilter<Object, Object> {
    private static final Log log = LogFactory.getLog(OfflineStatus.class);
    private static final long NO_FAILURE = -1L;
    private static final int MAX_RETRIES = 3;
    private final Supplier<TimeService> timeService;
    private final SiteStatusListener listener;
    private final ScopedState key;
    private final Cache<ScopedState, Long> globalState;
    private volatile TakeOfflineConfiguration takeOffline;
    @GuardedBy(value="this")
    private long firstFailureTime = -1L;
    @GuardedBy(value="this")
    private int failureCount = 0;
    @GuardedBy(value="this")
    private long localStatus = 0L;

    private static boolean isOnline(long localStatus) {
        return localStatus % 2L == 0L;
    }

    private static boolean isOffline(long localStatus) {
        return localStatus % 2L == 1L;
    }

    public OfflineStatus(TakeOfflineConfiguration takeOfflineConfiguration, Supplier<TimeService> timeService, SiteStatusListener listener, ScopedState key, Cache<ScopedState, Long> globalState) {
        this.takeOffline = takeOfflineConfiguration;
        this.timeService = timeService;
        this.listener = listener;
        this.key = key;
        this.globalState = globalState;
    }

    public void start() {
        this.globalState.addFilteredListener(this, this, null, Set.of(CacheEntryModified.class, CacheEntryCreated.class));
        Long existingStatus = (Long)this.globalState.get(this.key);
        if (existingStatus != null) {
            this.updateLocalStatus(existingStatus);
            return;
        }
        this.globalState.putIfAbsentAsync(this.key, 0L).thenAccept(status -> {
            if (status != null) {
                this.updateLocalStatus((long)status);
            }
        });
    }

    public void stop() {
        this.globalState.removeListener(this);
    }

    public synchronized void updateOnCommunicationFailure(long sendTimeMillis) {
        if (this.firstFailureTime == -1L) {
            this.firstFailureTime = sendTimeMillis;
        }
        ++this.failureCount;
        this.internalUpdateStatus();
    }

    public synchronized boolean isOffline() {
        return OfflineStatus.isOffline(this.localStatus);
    }

    public synchronized boolean minTimeHasElapsed() {
        if (this.firstFailureTime == -1L) {
            return false;
        }
        return this.internalMinTimeHasElapsed();
    }

    public synchronized long millisSinceFirstFailure() {
        return this.internalMillisSinceFirstFailure();
    }

    public synchronized boolean bringOnline() {
        return OfflineStatus.isOffline(this.localStatus) && this.internalReset();
    }

    public synchronized int getFailureCount() {
        return this.failureCount;
    }

    public synchronized boolean isEnabled() {
        return this.takeOffline.enabled();
    }

    public synchronized void reset() {
        this.internalReset();
    }

    public TakeOfflineConfiguration getTakeOffline() {
        return this.takeOffline;
    }

    public synchronized boolean forceOffline() {
        long status = this.localStatus;
        if (OfflineStatus.isOffline(status)) {
            return false;
        }
        this.switchGlobally(status);
        return true;
    }

    public synchronized String toString() {
        return "OfflineStatus{takeOffline=" + String.valueOf((Object)this.takeOffline) + ", recordingOfflineStatus=" + (this.firstFailureTime != -1L) + ", firstFailureTime=" + this.firstFailureTime + ", isOffline=" + OfflineStatus.isOffline(this.localStatus) + ", failureCount=" + this.failureCount + "}";
    }

    public void amend(Integer afterFailures, Long minTimeToWait) {
        TakeOfflineConfigurationBuilder builder = new TakeOfflineConfigurationBuilder(null, null);
        builder.read(this.getTakeOffline(), Combine.DEFAULT);
        if (afterFailures != null) {
            builder.afterFailures(afterFailures);
        }
        if (minTimeToWait != null) {
            builder.minTimeToWait(minTimeToWait);
        }
        this.amend(builder.create());
    }

    private void amend(TakeOfflineConfiguration takeOffline) {
        this.takeOffline = takeOffline;
        this.reset();
    }

    @GuardedBy(value="this")
    private void internalUpdateStatus() {
        boolean hasMinWait;
        if (OfflineStatus.isOffline(this.localStatus)) {
            return;
        }
        boolean bl = hasMinWait = this.takeOffline.minTimeToWait() > 0L;
        if (hasMinWait && !this.internalMinTimeHasElapsed()) {
            return;
        }
        long minFailures = this.takeOffline.afterFailures();
        if (minFailures > 0L) {
            if (minFailures <= (long)this.failureCount) {
                if (log.isTraceEnabled()) {
                    log.tracef("Site is failed: min failures (%s) reached (count=%s).", minFailures, this.failureCount);
                }
                this.switchGlobally(this.localStatus);
            }
        } else if (hasMinWait) {
            if (log.isTraceEnabled()) {
                log.trace("Site is failed: minTimeToWait elapsed and we don't have a min failure number to wait for.");
            }
            this.switchGlobally(this.localStatus);
        }
    }

    @GuardedBy(value="this")
    private boolean internalMinTimeHasElapsed() {
        long minTimeToWait = this.takeOffline.minTimeToWait();
        if (minTimeToWait <= 0L) {
            throw new IllegalStateException("Cannot invoke this method if minTimeToWait is not enabled");
        }
        long millis = this.internalMillisSinceFirstFailure();
        if (millis >= minTimeToWait) {
            if (log.isTraceEnabled()) {
                log.tracef("The minTimeToWait has passed: minTime=%s, timeSinceFirstFailure=%s", minTimeToWait, millis);
            }
            return true;
        }
        return false;
    }

    @GuardedBy(value="this")
    private boolean internalReset() {
        boolean wasOffline = OfflineStatus.isOffline(this.localStatus);
        this.firstFailureTime = -1L;
        this.failureCount = 0;
        if (wasOffline) {
            this.switchGlobally(this.localStatus);
        }
        return wasOffline;
    }

    @GuardedBy(value="this")
    private long internalMillisSinceFirstFailure() {
        return this.timeService.get().timeDuration(TimeUnit.MILLISECONDS.toNanos(this.firstFailureTime), TimeUnit.MILLISECONDS);
    }

    private void switchGlobally(long currentStatus) {
        this.replaceInCache(currentStatus, currentStatus + 1L, 0);
        this.updateLocalStatus(currentStatus + 1L);
    }

    private void replaceInCache(long oldStatus, long newStatus, int retry) {
        this.globalState.replaceAsync(this.key, oldStatus, newStatus).exceptionally(ignored -> {
            if (retry <= 3) {
                this.replaceInCache(oldStatus, newStatus, retry + 1);
            }
            return Boolean.TRUE;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalStatus(long newStatus) {
        OfflineStatus offlineStatus = this;
        synchronized (offlineStatus) {
            if (newStatus <= this.localStatus) {
                return;
            }
            this.localStatus = newStatus;
        }
        if (OfflineStatus.isOnline(newStatus)) {
            this.listener.siteOnline();
        } else {
            this.listener.siteOffline();
        }
    }

    @Override
    public synchronized boolean accept(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
        Long newStatus;
        return Objects.equals(key, this.key) && newValue instanceof Long && (newStatus = (Long)newValue) > this.localStatus;
    }

    @CacheEntryCreated
    @CacheEntryModified
    public void onStatusChanged(CacheEntryEvent<ScopedState, Long> event) {
        assert (!event.isPre());
        assert (event.getValue() != null);
        assert (Objects.equals(this.key, event.getKey()));
        this.updateLocalStatus(event.getValue());
    }
}

