/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.clientpolicy.executor;

import java.util.Collections;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.grants.ciba.clientpolicy.executor.SecureCibaSessionEnforceExecutor;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;

public class SecureCibaSessionEnforceExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "secure-ciba-session";

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new SecureCibaSessionEnforceExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "To distinguish which authentication belongs to which CIBA flow, it refuses backchannel authentication request which lacks 'binding_message' parameter.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }
}

