/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.wildfly.security.ssl.AbstractDelegatingSSLContextSpi;
import org.wildfly.security.ssl.ConfiguredSSLEngine;
import org.wildfly.security.ssl.ConfiguredSSLServerSocketFactory;
import org.wildfly.security.ssl.ConfiguredSSLSocketFactory;
import org.wildfly.security.ssl.SSLConfigurator;

final class ConfiguredSSLContextSpi
extends AbstractDelegatingSSLContextSpi {
    private final SSLConfigurator sslConfigurator;
    private final boolean wrap;

    ConfiguredSSLContextSpi(SSLContext delegate, SSLConfigurator sslConfigurator, boolean wrap) {
        super(delegate);
        this.sslConfigurator = sslConfigurator;
        this.wrap = wrap;
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new ConfiguredSSLSocketFactory(super.engineGetSocketFactory(), this.getDelegate(), this.sslConfigurator, this.wrap);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new ConfiguredSSLServerSocketFactory(super.engineGetServerSocketFactory(), this.getDelegate(), this.sslConfigurator, this.wrap);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        SSLEngine sslEngine = super.engineCreateSSLEngine();
        SSLConfigurator sslConfigurator = this.sslConfigurator;
        sslConfigurator.configure(this.getDelegate(), sslEngine);
        return this.wrap ? new ConfiguredSSLEngine(sslEngine, this.getDelegate(), sslConfigurator) : sslEngine;
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        SSLEngine sslEngine = super.engineCreateSSLEngine(host, port);
        SSLConfigurator sslConfigurator = this.sslConfigurator;
        sslConfigurator.configure(this.getDelegate(), sslEngine);
        return this.wrap ? new ConfiguredSSLEngine(sslEngine, this.getDelegate(), sslConfigurator) : sslEngine;
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        SSLContext delegate = this.getDelegate();
        return this.sslConfigurator.getDefaultSSLParameters(delegate, delegate.getDefaultSSLParameters());
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        SSLContext delegate = this.getDelegate();
        return this.sslConfigurator.getSupportedSSLParameters(delegate, delegate.getSupportedSSLParameters());
    }
}

