/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.AbstractJsonSetFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.UnparsedNumericLiteral;
import org.hibernate.type.spi.TypeConfiguration;

public class SingleStoreJsonSetFunction
extends AbstractJsonSetFunction {
    public SingleStoreJsonSetFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> translator) {
        Expression json = (Expression)arguments.get(0);
        Expression jsonPath = (Expression)arguments.get(1);
        List jsonPathElements = JsonPathHelper.parseJsonPathElements((String)((String)translator.getLiteralValue(jsonPath)));
        SqlAstNode value = arguments.get(2);
        sqlAppender.appendSql("json_set_");
        sqlAppender.appendSql(SingleStoreJsonSetFunction.isNumeric(value) ? "double(" : "string(");
        json.accept(translator);
        for (JsonPathHelper.JsonPathElement pathElement : jsonPathElements) {
            sqlAppender.appendSql(',');
            if (pathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)pathElement;
                sqlAppender.appendSingleQuoteEscapedString(attribute.attribute());
                continue;
            }
            if (pathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                String parameterName = ((JsonPathHelper.JsonParameterIndexAccess)pathElement).parameterName();
                throw new QueryException("JSON path [" + String.valueOf(jsonPath) + "] uses parameter [" + parameterName + "] that is not passed");
            }
            sqlAppender.appendSql('\'');
            sqlAppender.appendSql(((JsonPathHelper.JsonIndexAccess)pathElement).index());
            sqlAppender.appendSql('\'');
        }
        sqlAppender.appendSql(',');
        value.accept(translator);
        sqlAppender.appendSql(')');
    }

    private static boolean isNumeric(SqlAstNode value) {
        return value instanceof UnparsedNumericLiteral;
    }
}

