/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.condition.ClientUpdaterSourceRolesCondition;

public class ClientUpdaterSourceRolesConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "client-updater-source-roles";
    public static final String ROLES = "roles";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new ClientUpdaterSourceRolesCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition checks the role of the entity who tries to create/update the client to determine whether the policy is applied.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ClientUpdaterSourceRolesConditionFactory.addCommonConfigProperties(configProperties);
        ProviderConfigProperty property = new ProviderConfigProperty(ROLES, "client-updater-source-roles.label", "client-updater-source-roles.tooltip", "MultivaluedString", (Object)"admin");
        configProperties.add(property);
    }
}

