/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.AbstractParameter;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parser;

public class IntParameter
extends AbstractParameter<Integer> {
    public IntParameter() {
        this.setType(ParameterType.INT);
        this.setMultiplicity(false);
    }

    public IntParameter(String string) {
        this(string, null);
    }

    public IntParameter(String string, Integer n) {
        this();
        this.setName(string);
        this.setValue(n);
    }

    protected IntParameter(String[] stringArray) throws LscpException {
        this();
        this.parseLines(stringArray);
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("RANGE_MIN: ")) {
            string = string.substring("RANGE_MIN: ".length(), string.length());
            try {
                this.setRangeMin(Integer.parseInt(string));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notInt!", "RANGE_MIN"), numberFormatException);
            }
        }
        if (string.startsWith("RANGE_MAX: ")) {
            string = string.substring("RANGE_MAX: ".length(), string.length());
            try {
                this.setRangeMax(Integer.parseInt(string));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notInt!", "RANGE_MAX"), numberFormatException);
            }
        }
        if (string.startsWith("DEFAULT: ")) {
            string = string.substring("DEFAULT: ".length(), string.length());
            try {
                this.setDefault(Integer.parseInt(string));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("notInt!", "DEFAULT"), numberFormatException);
            }
        }
        if (string.startsWith("POSSIBILITIES: ")) {
            string = string.substring("POSSIBILITIES: ".length(), string.length());
            this.setPossibilities(Parser.parseIntList(string));
            return true;
        }
        return false;
    }

    @Override
    public void parseValue(String string) throws LscpException {
        this.setValue(Parser.parseInt(string));
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.getValue());
    }
}

