/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiMethodUtil;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.j2k.CommonSearchUtilsKt;
import org.jetbrains.kotlin.j2k.CommonUtilsKt;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.OldSearchUtilsKt;
import org.jetbrains.kotlin.j2k.ReferenceSearcher;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.LiteralExpression;
import org.jetbrains.kotlin.j2k.ast.MethodCallExpression;
import org.jetbrains.kotlin.j2k.ast.Mutability;
import org.jetbrains.kotlin.j2k.ast.PrimitiveType;
import org.jetbrains.kotlin.j2k.ast.Property;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\b*\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014H\u0007\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0011*\u00020\u0014H\u0007\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0013*\u00020\u0014\u001a\n\u0010\u0017\u001a\u00020\b*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u001a\u001a\n\u0010\u001b\u001a\u00020\b*\u00020\u0013\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0014*\u00020\u000e\u001a\f\u0010\u001d\u001a\u0004\u0018\u00010\u0014*\u00020\u001e\u001a\f\u0010\u001f\u001a\u0004\u0018\u00010\u0014*\u00020\u001e\u001a\u0012\u0010 \u001a\u00020\b*\u00020\u00182\u0006\u0010!\u001a\u00020\"\u001a\u0010\u0010#\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010\u0014\u001a\u001e\u0010%\u001a\u0004\u0018\u00010\u0001*\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020)\u001a\u001e\u0010*\u001a\u0004\u0018\u00010+*\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020)\"\u001d\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u00060"}, d2={"quoteKeywords", "", "packageName", "getDefaultInitializer", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "property", "Lorg/jetbrains/kotlin/j2k/ast/Property;", "shouldGenerateDefaultInitializer", "", "searcher", "Lorg/jetbrains/kotlin/j2k/ReferenceSearcher;", "field", "Lcom/intellij/psi/PsiField;", "isQualifierEmptyOrThis", "Lcom/intellij/psi/PsiReferenceExpression;", "isQualifierEmptyOrClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "getContainingMethod", "Lcom/intellij/psi/PsiMethod;", "Lcom/intellij/psi/PsiElement;", "getContainingClass", "getContainingConstructor", "isConstructor", "Lcom/intellij/psi/PsiMember;", "accessModifier", "Lcom/intellij/psi/PsiModifierListOwner;", "isMainMethod", "dot", "lPar", "Lcom/intellij/psi/PsiExpressionList;", "rPar", "isImported", "file", "Lcom/intellij/psi/PsiJavaFile;", "isFacadeClassFromLibrary", "element", "convertToKotlinAnalog", "Lorg/jetbrains/kotlin/j2k/Converter;", "classQualifiedName", "mutability", "Lorg/jetbrains/kotlin/j2k/ast/Mutability;", "convertToKotlinAnalogIdentifier", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "toKotlinTypesMap", "", "getToKotlinTypesMap", "()Ljava/util/Map;", "kotlin.j2k.k1.old"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/j2k/UtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,136:1\n12970#2,2:137\n12970#2,2:139\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/j2k/UtilsKt\n*L\n92#1:137,2\n97#1:139,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Map<String, String> toKotlinTypesMap;

    @NotNull
    public static final String quoteKeywords(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        char[] cArray = new char[]{'.'};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)packageName, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, UtilsKt::quoteKeywords$lambda$0, (int)30, null);
    }

    @Nullable
    public static final Expression getDefaultInitializer(@NotNull Property property) {
        Expression result2;
        Expression expression;
        block17: {
            block18: {
                Type t;
                block16: {
                    Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                    t = property.getType();
                    if (!t.isNullable()) break block16;
                    expression = new LiteralExpression("null");
                    break block17;
                }
                if (!(t instanceof PrimitiveType)) break block18;
                switch (((PrimitiveType)t).getName().getName()) {
                    case "Boolean": {
                        expression = new LiteralExpression("false");
                        break;
                    }
                    case "Char": {
                        expression = new LiteralExpression("' '");
                        break;
                    }
                    case "Double": {
                        Expression expression2 = (Expression)ElementKt.assignNoPrototype((Element)new LiteralExpression("0"));
                        String string = OperatorConventions.DOUBLE.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        expression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, expression2, string, null, null, null, 28, null);
                        break;
                    }
                    case "Float": {
                        Expression expression3 = (Expression)ElementKt.assignNoPrototype((Element)new LiteralExpression("0"));
                        String string = OperatorConventions.FLOAT.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        expression = MethodCallExpression.Companion.buildNonNull$default(MethodCallExpression.Companion, expression3, string, null, null, null, 28, null);
                        break;
                    }
                    default: {
                        expression = new LiteralExpression("0");
                        break;
                    }
                }
                break block17;
            }
            expression = null;
        }
        Expression expression4 = result2 = expression;
        return expression4 != null ? (Expression)ElementKt.assignNoPrototype((Element)expression4) : null;
    }

    public static final boolean shouldGenerateDefaultInitializer(@NotNull ReferenceSearcher searcher2, @NotNull PsiField field2) {
        Intrinsics.checkNotNullParameter((Object)searcher2, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        return field2.getInitializer() == null && (OldSearchUtilsKt.isVar(field2, searcher2) || !CommonSearchUtilsKt.hasWriteAccesses((PsiVariable)field2, searcher2, (PsiElement)field2.getContainingClass()));
    }

    public static final boolean isQualifierEmptyOrThis(@NotNull PsiReferenceExpression $this$isQualifierEmptyOrThis) {
        Intrinsics.checkNotNullParameter((Object)$this$isQualifierEmptyOrThis, (String)"<this>");
        PsiExpression qualifier2 = $this$isQualifierEmptyOrThis.getQualifierExpression();
        return qualifier2 == null || qualifier2 instanceof PsiThisExpression && ((PsiThisExpression)qualifier2).getQualifier() == null;
    }

    public static final boolean isQualifierEmptyOrClass(@NotNull PsiReferenceExpression $this$isQualifierEmptyOrClass, @NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isQualifierEmptyOrClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        PsiExpression qualifier2 = $this$isQualifierEmptyOrClass.getQualifierExpression();
        return qualifier2 == null || qualifier2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier2).isReferenceTo((PsiElement)psiClass);
    }

    @Deprecated(message="This declaration will be removed in a future release along with the whole Old J2K module")
    @Nullable
    public static final PsiMethod getContainingMethod(@NotNull PsiElement $this$getContainingMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingMethod, (String)"<this>");
        PsiElement context2 = $this$getContainingMethod.getContext();
        while (context2 != null) {
            PsiElement _context = context2;
            if (_context instanceof PsiMethod) {
                return (PsiMethod)_context;
            }
            context2 = _context.getContext();
        }
        return null;
    }

    @Deprecated(message="This declaration will be removed in a future release along with the whole Old J2K module")
    @Nullable
    public static final PsiClass getContainingClass(@NotNull PsiElement $this$getContainingClass) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingClass, (String)"<this>");
        PsiElement context2 = $this$getContainingClass.getContext();
        while (context2 != null) {
            PsiElement _context = context2;
            if (_context instanceof PsiClass) {
                return (PsiClass)_context;
            }
            if (_context instanceof PsiMember) {
                return ((PsiMember)_context).getContainingClass();
            }
            context2 = _context.getContext();
        }
        return null;
    }

    @Nullable
    public static final PsiMethod getContainingConstructor(@NotNull PsiElement $this$getContainingConstructor) {
        PsiMethod method;
        Intrinsics.checkNotNullParameter((Object)$this$getContainingConstructor, (String)"<this>");
        PsiMethod psiMethod = method = UtilsKt.getContainingMethod($this$getContainingConstructor);
        return (psiMethod != null ? psiMethod.isConstructor() : false) ? method : null;
    }

    public static final boolean isConstructor(@NotNull PsiMember $this$isConstructor) {
        Intrinsics.checkNotNullParameter((Object)$this$isConstructor, (String)"<this>");
        return $this$isConstructor instanceof PsiMethod && ((PsiMethod)$this$isConstructor).isConstructor();
    }

    @NotNull
    public static final String accessModifier(@NotNull PsiModifierListOwner $this$accessModifier) {
        Intrinsics.checkNotNullParameter((Object)$this$accessModifier, (String)"<this>");
        return $this$accessModifier.hasModifierProperty("public") ? "public" : ($this$accessModifier.hasModifierProperty("private") ? "private" : ($this$accessModifier.hasModifierProperty("protected") ? "protected" : "packageLocal"));
    }

    public static final boolean isMainMethod(@NotNull PsiMethod $this$isMainMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isMainMethod, (String)"<this>");
        return PsiMethodUtil.isMainMethod((PsiMethod)$this$isMainMethod);
    }

    @Nullable
    public static final PsiElement dot(@NotNull PsiReferenceExpression $this$dot) {
        Intrinsics.checkNotNullParameter((Object)$this$dot, (String)"<this>");
        ASTNode aSTNode = $this$dot.getNode().findChildByType(JavaTokenType.DOT);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static final PsiElement lPar(@NotNull PsiExpressionList $this$lPar) {
        Intrinsics.checkNotNullParameter((Object)$this$lPar, (String)"<this>");
        ASTNode aSTNode = $this$lPar.getNode().findChildByType(JavaTokenType.LPARENTH);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static final PsiElement rPar(@NotNull PsiExpressionList $this$rPar) {
        Intrinsics.checkNotNullParameter((Object)$this$rPar, (String)"<this>");
        ASTNode aSTNode = $this$rPar.getNode().findChildByType(JavaTokenType.RPARENTH);
        return aSTNode != null ? aSTNode.getPsi() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isImported(@NotNull PsiMember $this$isImported, @NotNull PsiJavaFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$isImported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if ($this$isImported instanceof PsiClass) {
            String string;
            int index2;
            String fqName2;
            String string2 = fqName2 = ((PsiClass)$this$isImported).getQualifiedName();
            int n = index2 = string2 != null ? StringsKt.lastIndexOf$default((CharSequence)string2, (char)'.', (int)0, (boolean)false, (int)6, null) : -1;
            if (index2 >= 0) {
                String string3 = fqName2;
                Intrinsics.checkNotNull((Object)string3);
                String string4 = string3.substring(0, index2);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            } else {
                string = null;
            }
            String parentName = string;
            PsiImportStatementBase[] psiImportStatementBaseArray = file.getImportList();
            PsiImportStatementBase[] psiImportStatementBaseArray2 = psiImportStatementBaseArray;
            if (psiImportStatementBaseArray == null) return false;
            PsiImportStatementBase[] psiImportStatementBaseArray3 = psiImportStatementBaseArray2.getAllImportStatements();
            psiImportStatementBaseArray2 = psiImportStatementBaseArray3;
            if (psiImportStatementBaseArray3 == null) return false;
            PsiImportStatementBase[] $this$any$iv = psiImportStatementBaseArray2;
            boolean $i$f$any = false;
            int n2 = 0;
            int n3 = $this$any$iv.length;
            while (n2 < n3) {
                PsiImportStatementBase element$iv;
                PsiImportStatementBase it = element$iv = $this$any$iv[n2];
                boolean bl = false;
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = it.getImportReference();
                if (Intrinsics.areEqual((Object)(psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getQualifiedName() : null), (Object)(it.isOnDemand() ? parentName : fqName2))) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if ($this$isImported.getContainingClass() == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray = file.getImportList();
        PsiImportStaticStatement[] psiImportStaticStatementArray2 = psiImportStaticStatementArray;
        if (psiImportStaticStatementArray == null) return false;
        PsiImportStaticStatement[] psiImportStaticStatementArray3 = psiImportStaticStatementArray2.getImportStaticStatements();
        psiImportStaticStatementArray2 = psiImportStaticStatementArray3;
        if (psiImportStaticStatementArray3 == null) return false;
        PsiImportStaticStatement[] $this$any$iv = psiImportStaticStatementArray2;
        boolean $i$f$any = false;
        int n = 0;
        int n4 = $this$any$iv.length;
        while (n < n4) {
            PsiImportStaticStatement element$iv;
            PsiImportStaticStatement it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.resolveTargetClass(), (Object)$this$isImported.getContainingClass())) {
                if (it.isOnDemand()) return true;
                if (Intrinsics.areEqual((Object)it.getReferenceName(), (Object)$this$isImported.getName())) {
                    return true;
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final boolean isFacadeClassFromLibrary(@Nullable PsiElement element) {
        return element instanceof KtLightClass && ((KtLightClass)element).getKotlinOrigin() == null;
    }

    @Nullable
    public static final String convertToKotlinAnalog(@NotNull Converter $this$convertToKotlinAnalog, @Nullable String classQualifiedName, @NotNull Mutability mutability) {
        Intrinsics.checkNotNullParameter((Object)$this$convertToKotlinAnalog, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)mutability), (String)"mutability");
        if (classQualifiedName == null) {
            return null;
        }
        String string = TypesKt.isMutable(mutability) ? CommonUtilsKt.getToKotlinMutableTypesMap().get(classQualifiedName) : null;
        if (string == null) {
            string = toKotlinTypesMap.get(classQualifiedName);
        }
        return string;
    }

    @Nullable
    public static final Identifier convertToKotlinAnalogIdentifier(@NotNull Converter $this$convertToKotlinAnalogIdentifier, @Nullable String classQualifiedName, @NotNull Mutability mutability) {
        Intrinsics.checkNotNullParameter((Object)$this$convertToKotlinAnalogIdentifier, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)mutability), (String)"mutability");
        String string = UtilsKt.convertToKotlinAnalog($this$convertToKotlinAnalogIdentifier, classQualifiedName, mutability);
        if (string == null) {
            return null;
        }
        String kotlinClassName = string;
        return Identifier.Companion.withNoPrototype$default(Identifier.Companion, StringsKt.substringAfterLast$default((String)kotlinClassName, (char)'.', null, (int)2, null), false, false, null, 14, null);
    }

    @NotNull
    public static final Map<String, String> getToKotlinTypesMap() {
        return toKotlinTypesMap;
    }

    private static final CharSequence quoteKeywords$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Identifier.Companion.toKotlin(it);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"java.lang.Object", (Object)StandardNames.FqNames.any.asString()), TuplesKt.to((Object)"java.lang.Byte", (Object)StandardNames.FqNames._byte.asString()), TuplesKt.to((Object)"java.lang.Character", (Object)StandardNames.FqNames._char.asString()), TuplesKt.to((Object)"java.lang.Double", (Object)StandardNames.FqNames._double.asString()), TuplesKt.to((Object)"java.lang.Float", (Object)StandardNames.FqNames._float.asString()), TuplesKt.to((Object)"java.lang.Integer", (Object)StandardNames.FqNames._int.asString()), TuplesKt.to((Object)"java.lang.Long", (Object)StandardNames.FqNames._long.asString()), TuplesKt.to((Object)"java.lang.Short", (Object)StandardNames.FqNames._short.asString()), TuplesKt.to((Object)"java.lang.Boolean", (Object)StandardNames.FqNames._boolean.asString()), TuplesKt.to((Object)"java.lang.Iterable", (Object)StandardNames.FqNames.iterable.asString()), TuplesKt.to((Object)"java.util.Iterator", (Object)StandardNames.FqNames.iterator.asString()), TuplesKt.to((Object)"java.util.List", (Object)StandardNames.FqNames.list.asString()), TuplesKt.to((Object)"java.util.Collection", (Object)StandardNames.FqNames.collection.asString()), TuplesKt.to((Object)"java.util.Set", (Object)StandardNames.FqNames.set.asString()), TuplesKt.to((Object)"java.util.Map", (Object)StandardNames.FqNames.map.asString()), TuplesKt.to((Object)"java.util.Map.Entry", (Object)StandardNames.FqNames.mapEntry.asString()), TuplesKt.to((Object)ListIterator.class.getCanonicalName(), (Object)StandardNames.FqNames.listIterator.asString())};
        toKotlinTypesMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

