---
stage: GitLab Delivery
group: Operate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 設定方法。
title: GitLabを設定する
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

GitLab Self-Managedをカスタマイズおよび設定します。

- [管理者エリア](admin_area.md)
- [Kubernetes用エージェントサーバー](clusters/kas.md)
- [アプリケーションキャッシュ間隔](application_settings_cache.md)
- [セル](cells.md)
- [CI/CD](cicd/_index.md)
- [分析用ClickHouse](analytics.md)
- [Consul](consul.md)
- [Cron](../topics/cron/_index.md)
- [カスタムHTMLヘッダータグ](custom_html_header_tags.md)
- [環境変数](environment_variables.md)
- [ファイルフック](file_hooks.md)
- [Geo](geo/_index.md)
- [ディザスターリカバリー（Geo）](geo/disaster_recovery/_index.md)
- [Geoサイト](geo_sites.md)
- [Git LFSの管理](lfs/_index.md)
- [Gitプロトコルv2](git_protocol.md)
- [ヘルスチェック](monitoring/health_check.md)
- [製品ドキュメントをホスティングする](docs_self_host.md)
- [受信メール](incoming_email.md)
- [インスタンスの制限](instance_limits.md)
- [インスタンスレビュー](instance_review.md)
- [Markdownキャッシュを無効化する](invalidate_markdown_cache.md)
- [イシューのクローズパターン](issue_closing_pattern.md)
- [ラベル](labels.md)
- [ロードバランサー](load_balancer.md)
- [ログシステム](logs/_index.md)
- [マージリクエストの承認](merge_requests_approvals.md)
- [マージリクエストの差分ストレージ](merge_request_diffs.md)
- [NFS](nfs.md)
- [オブジェクトストレージ](object_storage.md)
- [パッケージ](packages/_index.md)
- [Postfix](reply_by_email_postfix_setup.md)
- [PostgreSQL](postgresql/_index.md)
- [Redis](redis/_index.md)
- [メールで返信](reply_by_email.md)
- [リポジトリのストレージ](repository_storage_paths.md)
- [サーバーフック](server_hooks.md)
- [Sidekiq](sidekiq/_index.md)
- [スニペット](snippets/_index.md)
- [S/MIME署名](smime_signing_email.md)
- [静的オブジェクト外部ストレージ](static_objects_external_storage.md)
- [Terraformの制限](settings/terraform_limits.md)
- [Terraformステート](terraform_state.md)
- [Time zone](timezone.md)（タイムゾーン）
- [アップロード](uploads.md)
- [Webターミナル](integration/terminal.md)
- [新機能](whats-new.md)
- [Wiki](wikis/_index.md)
