# frozen_string_literal: true

class FinalizeBackfillVulnerabilityFindingsRemediationsProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.7'

  disable_ddl_transaction!

  restrict_gitlab_migration gitlab_schema: :gitlab_main_org

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: 'BackfillVulnerabilityFindingsRemediationsProjectId',
      table_name: :vulnerability_findings_remediations,
      column_name: :id,
      job_arguments: [:project_id, :vulnerability_occurrences, :project_id, :vulnerability_occurrence_id],
      finalize: true
    )
  end

  def down; end
end
