/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.TreeSet;

public class ResponseName
extends QueryResponseRecord {
    public final DescriptionManager manage = new DescriptionManager();
    public boolean uniqueexecutable = false;
    public boolean printselfsig = false;
    public boolean printjustexe = false;

    public ResponseName() {
        super("responsename");
    }

    @Override
    public DescriptionManager getDescriptionManager() {
        return this.manage;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        if (this.uniqueexecutable) {
            fwrite.append("<uniqueexe>true</uniqueexe>\n");
        } else {
            fwrite.append("<uniqueexe>false</uniqueexe>\n");
        }
        if (this.printselfsig) {
            fwrite.append("<printselfsig>true</printselfsig>\n");
        } else {
            fwrite.append("<printselfsig>false</printselfsig>\n");
        }
        if (this.printjustexe) {
            fwrite.append("<printjustexe>true</printjustexe>\n");
        } else {
            fwrite.append("<printjustexe>false</printjustexe>\n");
        }
        this.manage.saveXml(fwrite);
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.uniqueexecutable = false;
        this.printselfsig = false;
        this.printjustexe = false;
        parser.start(new String[]{this.name});
        if (parser.peek().getName().equals("uniqueexe")) {
            parser.start(new String[0]);
            this.uniqueexecutable = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        }
        if (parser.peek().getName().equals("printselfsig")) {
            parser.start(new String[0]);
            this.printselfsig = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        }
        if (parser.peek().getName().equals("printjustexe")) {
            parser.start(new String[0]);
            this.printjustexe = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
        }
        this.manage.restoreXml(parser, vectorFactory);
        parser.end();
    }

    public void printRaw(PrintStream stream, LSHVectorFactory vectorFactory, int format) {
        if (!this.uniqueexecutable) {
            stream.println("Unable to resolve unique executable");
        }
        if (!this.uniqueexecutable || this.printjustexe) {
            TreeSet<ExecutableRecord> exeset = this.manage.getExecutableRecordSet();
            Iterator<ExecutableRecord> iter = exeset.iterator();
            while (iter.hasNext()) {
                String line = iter.next().printRaw();
                stream.println(line);
            }
            return;
        }
        ExecutableRecord lastexe = null;
        Iterator<FunctionDescription> iter = this.manage.listAllFunctions();
        while (iter.hasNext()) {
            String line;
            FunctionDescription funcrec = iter.next();
            if (lastexe != funcrec.getExecutableRecord()) {
                lastexe = funcrec.getExecutableRecord();
                line = lastexe.printRaw();
                stream.println(line);
            }
            stream.print("  ");
            if (this.printselfsig) {
                double val = 0.0;
                SignatureRecord srec = funcrec.getSignatureRecord();
                if (srec != null) {
                    val = vectorFactory.getSelfSignificance(srec.getLSHVector());
                }
                stream.print(val);
                stream.print(' ');
            }
            line = funcrec.printRaw();
            stream.println(line);
        }
    }
}

