/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.ByteSequenceLengthFilter;
import ghidra.bitpatterns.info.BytesAndDisassembly;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.FilteredBytesAndDisassembly;
import ghidra.bitpatterns.info.FunctionBitPatternInfo;
import ghidra.bitpatterns.info.InstructionSequence;
import ghidra.bitpatterns.info.InstructionSequenceTreePathFilter;
import ghidra.bitpatterns.info.PatternType;
import ghidra.util.bytesearch.DittedBitSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ByteSequenceRowObject {
    private String byteSequence;
    private String disassembly;
    private int numOccurrences;
    private double percentage;
    private static final int HEX_DIGITS_PER_BYTE = 2;

    public ByteSequenceRowObject(String byteSequence, String disassembly, int numOccurences, double percentage) {
        this.byteSequence = byteSequence;
        this.disassembly = disassembly;
        this.numOccurrences = numOccurences;
        this.percentage = percentage;
    }

    public static List<ByteSequenceRowObject> getFilteredRowObjects(List<FunctionBitPatternInfo> unfilteredInfo, PatternType type, ContextRegisterFilter registerFilter, ByteSequenceLengthFilter lengthFilter) {
        HashMap<String, Integer> byteSeqCounts = new HashMap<String, Integer>();
        HashMap<String, String> bytesToDisassembly = new HashMap<String, String>();
        int numTotalSeqs = 0;
        for (FunctionBitPatternInfo fInfo : unfilteredInfo) {
            if (ByteSequenceRowObject.failsFilter(fInfo, registerFilter)) continue;
            List<String> byteStrings = ByteSequenceRowObject.getAllByteStringsOfType(fInfo, type);
            FilteredBytesAndDisassembly fAndD = ByteSequenceRowObject.getFilteredBytesAndDisassembly(byteStrings, lengthFilter, fInfo, type);
            int numFilteredStrings = fAndD.getFilteredBytes().size();
            for (int i = 0; i < numFilteredStrings; ++i) {
                String currentFilteredByteString = fAndD.getFilteredBytes().get(i);
                String currentDis = (String)bytesToDisassembly.get(currentFilteredByteString);
                List<String> disassembly = fAndD.getDisassembly();
                if (!(currentDis != null && currentDis.length() >= disassembly.get(i).length() || disassembly.get(i).contains("null"))) {
                    bytesToDisassembly.put(currentFilteredByteString, disassembly.get(i));
                }
                if (byteSeqCounts.containsKey(currentFilteredByteString)) {
                    Integer count = (Integer)byteSeqCounts.get(currentFilteredByteString);
                    byteSeqCounts.put(currentFilteredByteString, count + 1);
                    ++numTotalSeqs;
                    continue;
                }
                byteSeqCounts.put(currentFilteredByteString, 1);
                ++numTotalSeqs;
            }
        }
        return ByteSequenceRowObject.getRowObjectsForLengthFilteredSeqs(byteSeqCounts, bytesToDisassembly, numTotalSeqs);
    }

    private static List<ByteSequenceRowObject> getRowObjectsForLengthFilteredSeqs(Map<String, Integer> byteSeqCounts, Map<String, String> bytesToDisassembly, int numTotalSeqs) {
        ArrayList<ByteSequenceRowObject> rowObjects = new ArrayList<ByteSequenceRowObject>();
        for (String bytes : byteSeqCounts.keySet()) {
            Integer count = byteSeqCounts.get(bytes);
            ByteSequenceRowObject rowObject = new ByteSequenceRowObject(bytes, bytesToDisassembly.get(bytes), count, 100.0 * (double)count.intValue() / (double)numTotalSeqs);
            rowObjects.add(rowObject);
        }
        return rowObjects;
    }

    private static FilteredBytesAndDisassembly getFilteredBytesAndDisassembly(List<String> byteStrings, ByteSequenceLengthFilter lengthFilter, FunctionBitPatternInfo fInfo, PatternType type) {
        ArrayList<String> disassembly = new ArrayList<String>();
        ArrayList<String> filteredByteStrings = new ArrayList<String>();
        int numStrings = byteStrings.size();
        for (int i = 0; i < numStrings; ++i) {
            String currentByteString = byteStrings.get(i);
            if (lengthFilter != null) {
                String filteredString = lengthFilter.filter(currentByteString);
                if (filteredString == null) continue;
                filteredByteStrings.add(filteredString);
                disassembly.add("partial bytestring");
                continue;
            }
            if (currentByteString == null) continue;
            filteredByteStrings.add(currentByteString);
            disassembly.add(ByteSequenceRowObject.getCompleteDisassembly(fInfo, type, type.equals((Object)PatternType.RETURN) ? i : 0));
        }
        FilteredBytesAndDisassembly fAndD = new FilteredBytesAndDisassembly(filteredByteStrings, disassembly);
        return fAndD;
    }

    private static List<String> getAllByteStringsOfType(FunctionBitPatternInfo fInfo, PatternType type) {
        ArrayList<String> byteStringList = new ArrayList<String>();
        switch (type) {
            case FIRST: {
                byteStringList.add(fInfo.getFirstBytes());
                break;
            }
            case PRE: {
                byteStringList.add(fInfo.getPreBytes());
                break;
            }
            case RETURN: {
                byteStringList.addAll(fInfo.getReturnBytes());
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported PatternType: " + type.name());
            }
        }
        return byteStringList;
    }

    private static String getCompleteDisassembly(FunctionBitPatternInfo fInfo, PatternType type, int i) {
        switch (type) {
            case FIRST: {
                return fInfo.getFirstInst().getCompleteDisassembly(true);
            }
            case PRE: {
                return fInfo.getPreInst().getCompleteDisassembly(false);
            }
            case RETURN: {
                return fInfo.getReturnInst().get(i).getCompleteDisassembly(false);
            }
        }
        throw new IllegalArgumentException("Unsupported PatternType: " + type.name());
    }

    private static String getDisassemblyForTreePath(InstructionSequence instSeq, InstructionSequenceTreePathFilter pathFilter) {
        int numInstructions = pathFilter.getInstructions().size();
        boolean inOrder = pathFilter.getInstructionType().equals((Object)PatternType.FIRST);
        return instSeq.getDisassembly(numInstructions, inOrder);
    }

    public String getSequence() {
        return this.byteSequence;
    }

    public String getDisassembly() {
        return this.disassembly;
    }

    public int getNumOccurrences() {
        return this.numOccurrences;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public static List<ByteSequenceRowObject> getRowObjectsFromInstructionSequences(List<FunctionBitPatternInfo> unfilteredInfo, InstructionSequenceTreePathFilter pathFilter, ContextRegisterFilter contextRegisterFilter) {
        int numBytes = pathFilter.getTotalLength();
        HashMap<BytesAndDisassembly, Integer> bytesAndDisCount = new HashMap<BytesAndDisassembly, Integer>();
        int numTotalSeqs = 0;
        for (FunctionBitPatternInfo fInfo : unfilteredInfo) {
            if (ByteSequenceRowObject.failsFilter(fInfo, contextRegisterFilter)) continue;
            List<InstructionSequence> instSeqs = ByteSequenceRowObject.getInstructionSequences(pathFilter, fInfo);
            int numSeqs = instSeqs.size();
            for (int i = 0; i < numSeqs; ++i) {
                InstructionSequence currentSeq = instSeqs.get(i);
                if (!pathFilter.allows(currentSeq)) continue;
                ++numTotalSeqs;
                String totalBytes = null;
                int totalBytesLen = 0;
                String bytes = null;
                String disassembly = null;
                switch (pathFilter.getInstructionType()) {
                    case FIRST: {
                        if (fInfo.getFirstBytes() == null) break;
                        totalBytes = fInfo.getFirstBytes();
                        bytes = totalBytes.substring(0, 2 * numBytes);
                        disassembly = ByteSequenceRowObject.getDisassemblyForTreePath(currentSeq, pathFilter);
                        break;
                    }
                    case PRE: {
                        if (fInfo.getPreBytes() == null) break;
                        totalBytes = fInfo.getPreBytes();
                        totalBytesLen = totalBytes.length();
                        bytes = totalBytes.substring(totalBytesLen - 2 * numBytes, totalBytesLen);
                        disassembly = ByteSequenceRowObject.getDisassemblyForTreePath(currentSeq, pathFilter);
                        break;
                    }
                    case RETURN: {
                        if (fInfo.getReturnBytes() == null || fInfo.getReturnBytes().size() <= i) break;
                        totalBytes = fInfo.getReturnBytes().get(i);
                        totalBytesLen = totalBytes.length();
                        bytes = totalBytes.substring(totalBytesLen - 2 * numBytes, totalBytesLen);
                        disassembly = ByteSequenceRowObject.getDisassemblyForTreePath(currentSeq, pathFilter);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported type: " + pathFilter.getInstructionType().name());
                    }
                }
                ByteSequenceRowObject.incrementCountMap(bytesAndDisCount, bytes, disassembly);
            }
        }
        return ByteSequenceRowObject.getRowObjectsForPathFilteredSeqs(bytesAndDisCount, numTotalSeqs);
    }

    private static List<ByteSequenceRowObject> getRowObjectsForPathFilteredSeqs(Map<BytesAndDisassembly, Integer> bytesAndDisCount, int numTotalSeqs) {
        ArrayList<ByteSequenceRowObject> returnRowObjects = new ArrayList<ByteSequenceRowObject>();
        for (BytesAndDisassembly bytesAndDisassembly : bytesAndDisCount.keySet()) {
            Integer count = bytesAndDisCount.get(bytesAndDisassembly);
            ByteSequenceRowObject rowObject = new ByteSequenceRowObject(bytesAndDisassembly.getBytes(), bytesAndDisassembly.getDisassembly(), count, 100.0 * (double)count.intValue() / (double)numTotalSeqs);
            returnRowObjects.add(rowObject);
        }
        return returnRowObjects;
    }

    private static boolean failsFilter(FunctionBitPatternInfo fInfo, ContextRegisterFilter cRegFilter) {
        if (cRegFilter == null) {
            return false;
        }
        return !cRegFilter.allows(fInfo.getContextRegisters());
    }

    private static void incrementCountMap(Map<BytesAndDisassembly, Integer> bytesAndDisCount, String bytes, String disassembly) {
        BytesAndDisassembly bytesAndDisassembly = new BytesAndDisassembly(bytes, disassembly);
        if (bytesAndDisCount.containsKey(bytesAndDisassembly)) {
            Integer count = bytesAndDisCount.get(bytesAndDisassembly);
            bytesAndDisCount.put(bytesAndDisassembly, count + 1);
        } else {
            bytesAndDisCount.put(bytesAndDisassembly, 1);
        }
    }

    private static List<InstructionSequence> getInstructionSequences(InstructionSequenceTreePathFilter pathFilter, FunctionBitPatternInfo fInfo) {
        ArrayList<InstructionSequence> instSeqs = new ArrayList<InstructionSequence>();
        switch (pathFilter.getInstructionType()) {
            case FIRST: {
                if (fInfo.getFirstBytes() == null) break;
                instSeqs.add(fInfo.getFirstInst());
                break;
            }
            case PRE: {
                if (fInfo.getPreBytes() == null) break;
                instSeqs.add(fInfo.getPreInst());
                break;
            }
            case RETURN: {
                List<String> retBytes = fInfo.getReturnBytes();
                if (retBytes.size() != fInfo.getReturnInst().size()) break;
                boolean valid = true;
                for (String bytes : retBytes) {
                    if (bytes != null) continue;
                    valid = false;
                }
                if (!valid) break;
                instSeqs.addAll(fInfo.getReturnInst());
                break;
            }
            default: {
                throw new IllegalArgumentException("bad type");
            }
        }
        return instSeqs;
    }

    public static DittedBitSequence merge(List<ByteSequenceRowObject> rowObjects) {
        if (rowObjects == null || rowObjects.size() == 0) {
            return null;
        }
        ArrayList<DittedBitSequence> dittedSeqs = new ArrayList<DittedBitSequence>();
        for (ByteSequenceRowObject currentRow : rowObjects) {
            DittedBitSequence currentSeq = new DittedBitSequence(currentRow.getSequence(), true);
            dittedSeqs.add(currentSeq);
        }
        DittedBitSequence currentMerge = (DittedBitSequence)dittedSeqs.get(0);
        int max = dittedSeqs.size();
        for (int i = 1; i < max; ++i) {
            currentMerge = new DittedBitSequence(currentMerge, (DittedBitSequence)dittedSeqs.get(i));
        }
        return currentMerge;
    }
}

