/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBHandle;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import javax.help.UnsupportedOperationException;

public class URLLinkObject
extends DomainObjectAdapterDB {
    private String linkPath;

    URLLinkObject(DBHandle dbh, Object consumer) throws IOException {
        super(dbh, "Untitled", 500, consumer);
        this.loadMetadata();
        this.linkPath = (String)this.metadata.get("link.url");
        if (this.linkPath == null) {
            throw new IOException("Null link path/URL");
        }
    }

    @Override
    public String getDescription() {
        return "Link-File";
    }

    public String getLinkPath() {
        return this.linkPath;
    }

    @Override
    public final boolean isChangeable() {
        return false;
    }

    @Override
    public final void saveToPackedFile(File outputFile, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }
}

