/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.CheckinHandler;
import ghidra.framework.data.FolderLinkContentHandler;
import ghidra.framework.data.LinkedGhidraFolder;
import ghidra.framework.data.LinkedGhidraSubFolder;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.LinkedDomainFile;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.help.UnsupportedOperationException;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;

class LinkedGhidraFile
implements LinkedDomainFile {
    private final LinkedGhidraSubFolder parent;
    private final String fileName;
    private final DomainFile realDomainFile;
    private final LinkFileInfo linkInfo;

    LinkedGhidraFile(LinkedGhidraSubFolder parent, DomainFile realDomainFile) {
        this.parent = parent;
        this.fileName = realDomainFile.getName();
        this.realDomainFile = realDomainFile;
        this.linkInfo = realDomainFile.isLink() ? new LinkedFileLinkInfo() : null;
    }

    @Override
    public DomainFile getRealFile() throws IOException {
        return this.parent.getLinkedFile(this.fileName);
    }

    @Override
    public DomainFolder getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkedGhidraFile)) {
            return false;
        }
        LinkedGhidraFile other = (LinkedGhidraFile)obj;
        return this.fileName.equals(other.fileName) && this.parent.equals(other.parent);
    }

    public int hashCode() {
        return this.getPathname().hashCode();
    }

    @Override
    public int compareTo(DomainFile df) {
        return this.fileName.compareToIgnoreCase(df.getName());
    }

    @Override
    public boolean exists() {
        DomainFile df = this.parent.getLinkedFileNoError(this.fileName);
        return df != null && df.exists();
    }

    @Override
    public String getFileID() {
        return this.realDomainFile.getFileID();
    }

    @Override
    public DomainFile setName(String newName) throws InvalidNameException, IOException {
        String name = this.getRealFile().setName(newName).getName();
        return this.parent.getFile(name);
    }

    @Override
    public String getPathname() {
        Object path = this.getParent().getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.fileName;
        return path;
    }

    @Override
    public URL getSharedProjectURL(String ref) {
        URL folderURL = this.parent.getSharedProjectURL();
        if (GhidraURL.isServerRepositoryURL(folderURL)) {
            try {
                Object spec = this.fileName;
                if (!StringUtils.isEmpty((CharSequence)ref)) {
                    spec = (String)spec + "#" + ref;
                }
                return new URL(folderURL, (String)spec);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public URL getLocalProjectURL(String ref) {
        ProjectLocator projectLocator = this.parent.getProjectLocator();
        if (!projectLocator.isTransient()) {
            return GhidraURL.makeURL(projectLocator, this.getPathname(), ref);
        }
        return null;
    }

    @Override
    public ProjectLocator getProjectLocator() {
        return this.parent.getProjectLocator();
    }

    @Override
    public String getContentType() {
        return this.realDomainFile.getContentType();
    }

    @Override
    public Class<? extends DomainObject> getDomainObjectClass() {
        return this.realDomainFile.getDomainObjectClass();
    }

    @Override
    public ChangeSet getChangesByOthersSinceCheckout() throws VersionException, IOException {
        return this.getRealFile().getChangesByOthersSinceCheckout();
    }

    @Override
    public DomainObject getDomainObject(Object consumer, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getRealFile().getDomainObject(consumer, okToUpgrade, okToRecover, monitor);
    }

    @Override
    public DomainObject getOpenedDomainObject(Object consumer) {
        return this.realDomainFile.getOpenedDomainObject(consumer);
    }

    @Override
    public DomainObject getReadOnlyDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getRealFile().getReadOnlyDomainObject(consumer, version, monitor);
    }

    @Override
    public DomainObject getImmutableDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        return this.getRealFile().getImmutableDomainObject(consumer, version, monitor);
    }

    @Override
    public void save(TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public boolean canRecover() {
        return false;
    }

    @Override
    public boolean takeRecoverySnapshot() throws IOException {
        return true;
    }

    @Override
    public boolean isInWritableProject() {
        return this.parent.isInWritableProject();
    }

    @Override
    public long getLastModifiedTime() {
        return this.realDomainFile.getLastModifiedTime();
    }

    @Override
    public Icon getIcon(boolean disabled) {
        return this.realDomainFile.getIcon(disabled);
    }

    @Override
    public boolean isCheckedOut() {
        return this.realDomainFile.isCheckedOut();
    }

    @Override
    public boolean isCheckedOutExclusive() {
        return this.realDomainFile.isCheckedOutExclusive();
    }

    @Override
    public boolean modifiedSinceCheckout() {
        return this.realDomainFile.modifiedSinceCheckout();
    }

    @Override
    public boolean canCheckout() {
        return this.realDomainFile.canCheckout();
    }

    @Override
    public boolean canCheckin() {
        return this.realDomainFile.canCheckin();
    }

    @Override
    public boolean canMerge() {
        return this.realDomainFile.canMerge();
    }

    @Override
    public boolean canAddToRepository() {
        return this.realDomainFile.canAddToRepository();
    }

    @Override
    public void setReadOnly(boolean state) throws IOException {
        this.getRealFile().setReadOnly(state);
    }

    @Override
    public boolean isReadOnly() {
        return this.realDomainFile.isReadOnly();
    }

    @Override
    public boolean isVersioned() {
        return this.realDomainFile.isVersioned();
    }

    @Override
    public boolean isHijacked() {
        return this.realDomainFile.isHijacked();
    }

    @Override
    public int getLatestVersion() {
        return this.realDomainFile.getLatestVersion();
    }

    @Override
    public boolean isLatestVersion() {
        return this.realDomainFile.isLatestVersion();
    }

    @Override
    public int getVersion() {
        return this.realDomainFile.getVersion();
    }

    @Override
    public Version[] getVersionHistory() throws IOException {
        DomainFile df = this.getRealFile();
        return df != null ? df.getVersionHistory() : new Version[]{};
    }

    @Override
    public void addToVersionControl(String comment, boolean keepCheckedOut, TaskMonitor monitor) throws IOException, CancelledException {
        this.getRealFile().addToVersionControl(comment, keepCheckedOut, monitor);
    }

    @Override
    public boolean checkout(boolean exclusive, TaskMonitor monitor) throws IOException, CancelledException {
        return this.getRealFile().checkout(exclusive, monitor);
    }

    @Override
    public void checkin(CheckinHandler checkinHandler, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.getRealFile().checkin(checkinHandler, monitor);
    }

    @Override
    public void merge(boolean okToUpgrade, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        this.getRealFile().merge(okToUpgrade, monitor);
    }

    @Override
    public void undoCheckout(boolean keep) throws IOException {
        this.getRealFile().undoCheckout(keep);
    }

    @Override
    public void undoCheckout(boolean keep, boolean force) throws IOException {
        this.getRealFile().undoCheckout(keep, force);
    }

    @Override
    public void terminateCheckout(long checkoutId) throws IOException {
        this.getRealFile().terminateCheckout(checkoutId);
    }

    @Override
    public ItemCheckoutStatus[] getCheckouts() throws IOException {
        return this.getRealFile().getCheckouts();
    }

    @Override
    public ItemCheckoutStatus getCheckoutStatus() throws IOException {
        return this.getRealFile().getCheckoutStatus();
    }

    @Override
    public void delete() throws IOException {
        this.getRealFile().delete();
    }

    @Override
    public void delete(int version) throws IOException {
        this.getRealFile().delete(version);
    }

    @Override
    public DomainFile moveTo(DomainFolder newParent) throws IOException {
        return this.getRealFile().moveTo(newParent);
    }

    @Override
    public DomainFile copyTo(DomainFolder newParent, TaskMonitor monitor) throws IOException, CancelledException {
        return this.getRealFile().copyTo(newParent, monitor);
    }

    @Override
    public DomainFile copyVersionTo(int version, DomainFolder destFolder, TaskMonitor monitor) throws IOException, CancelledException {
        return this.getRealFile().copyVersionTo(version, destFolder, monitor);
    }

    @Override
    public DomainFile copyToAsLink(DomainFolder newParent, boolean relative) throws IOException {
        return this.getRealFile().copyToAsLink(newParent, relative);
    }

    @Override
    public boolean isLinkingSupported() {
        return this.realDomainFile.isLinkingSupported();
    }

    @Override
    public List<?> getConsumers() {
        return List.of();
    }

    @Override
    public boolean isChanged() {
        return this.realDomainFile.isChanged();
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void packFile(File file, TaskMonitor monitor) throws IOException, CancelledException {
        this.getRealFile().packFile(file, monitor);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.realDomainFile.getMetadata();
    }

    @Override
    public long length() throws IOException {
        return this.realDomainFile.length();
    }

    @Override
    public boolean isLink() {
        return this.linkInfo != null;
    }

    @Override
    public LinkFileInfo getLinkInfo() {
        return this.linkInfo;
    }

    @Override
    public String getLinkedPathname() {
        return this.parent.getLinkedPathname(this.fileName);
    }

    public String toString() {
        return this.getPathname() + "->" + this.realDomainFile.getPathname();
    }

    private class LinkedFileLinkInfo
    implements LinkFileInfo {
        private LinkedFileLinkInfo() {
        }

        @Override
        public DomainFile getFile() {
            return LinkedGhidraFile.this;
        }

        @Override
        public LinkedGhidraFolder getLinkedFolder() {
            try {
                return FolderLinkContentHandler.getLinkedFolder(LinkedGhidraFile.this);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public String getLinkPath() {
            return LinkedGhidraFile.this.realDomainFile.getLinkInfo().getLinkPath();
        }

        @Override
        public String getAbsoluteLinkPath() throws IOException {
            return LinkedGhidraFile.this.realDomainFile.getLinkInfo().getAbsoluteLinkPath();
        }
    }
}

