/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint.slicetree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.decompiler.taint.TaintSliceTreeProvider;
import ghidra.app.plugin.core.decompiler.taint.slicetree.SliceNode;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.commons.collections4.map.LazyMap;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public class InSliceNode
extends SliceNode {
    private Icon INCOMING_FUNCTION_ICON;
    private Icon icon = null;
    private final Address functionAddress;
    protected final Program program;
    protected final Function function;
    protected String name;
    protected final boolean filterDuplicates;
    private final Address sourceAddress;

    InSliceNode(Program program, Function function, Address sourceAddress, boolean filterDuplicates, AtomicInteger filterDepth) {
        super(filterDepth);
        this.program = program;
        this.function = function;
        this.name = function.getName();
        this.sourceAddress = sourceAddress;
        this.filterDuplicates = filterDuplicates;
        this.functionAddress = function.getEntryPoint();
        MultiIcon incomingFunctionIcon = new MultiIcon(TaintSliceTreeProvider.IN_TAINT_ICON, false, 32, 16);
        TranslateIcon translateIcon = new TranslateIcon(TaintSliceTreeProvider.HIGH_FUNCTION_ICON, 16, 0);
        incomingFunctionIcon.addIcon((Icon)translateIcon);
        this.INCOMING_FUNCTION_ICON = incomingFunctionIcon;
        this.setAllowsDuplicates(!filterDuplicates);
    }

    @Override
    public SliceNode recreate() {
        return new InSliceNode(this.program, this.function, this.sourceAddress, this.filterDuplicates, this.filterDepth);
    }

    @Override
    public Function getRemoteFunction() {
        return this.function;
    }

    @Override
    public ProgramLocation getLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        FunctionSignatureFieldLocation location = new FunctionSignatureFieldLocation(this.program, this.functionAddress);
        Set addresses = ReferenceUtils.getReferenceAddresses((ProgramLocation)location, (TaskMonitor)monitor);
        LazyMap nodesByFunction = LazyMap.lazyMap(new HashMap(), k -> new ArrayList());
        FunctionManager functionManager = this.program.getFunctionManager();
        for (Address fromAddress : addresses) {
            monitor.checkCancelled();
            Function callerFunction = functionManager.getFunctionContaining(fromAddress);
            if (callerFunction == null) continue;
            InSliceNode node = new InSliceNode(this.program, callerFunction, fromAddress, this.filterDuplicates, this.filterDepth);
            this.addNode((LazyMap<Function, List<GTreeNode>>)nodesByFunction, node);
        }
        List<GTreeNode> children = nodesByFunction.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
        Collections.sort(children, new SliceNode.CallNodeComparator(this));
        return children;
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public Icon getIcon(boolean expanded) {
        if (this.icon == null) {
            this.icon = this.INCOMING_FUNCTION_ICON;
        }
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }
}

