/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintLabelsDataFrame;
import ghidra.app.plugin.core.decompiler.taint.TaintLabelsTableProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighVariable;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TaintLabelsTableModelFactory {
    private List<String> sColumns;

    public TaintLabelsTableModelFactory(List<String> cols) {
        this.sColumns = cols;
    }

    public TaintLabelsTableModel createModel(String description, TaintPlugin plugin, Program program, TaintLabelsDataFrame df, TaintLabelsTableProvider provider) {
        return new TaintLabelsTableModel(description, plugin, program, df, provider);
    }

    public class TaintLabelsTableModel
    extends AddressBasedTableModel<Map<String, Object>> {
        private static final long serialVersionUID = 1L;
        private TaintLabelsDataFrame df;
        private TaintLabelsTableProvider provider;
        private TaintPlugin plugin;

        public TaintLabelsTableModel(String description, TaintPlugin plugin, Program program, TaintLabelsDataFrame df, TaintLabelsTableProvider provider) {
            super(description, (ServiceProvider)plugin.getTool(), program, null);
            this.df = df;
            this.provider = provider;
            this.plugin = plugin;
        }

        public boolean isCellEditable(int row, int col) {
            String colName = this.getColumnName(col);
            return colName == "Selected" || colName == "Label";
        }

        public void setValueAt(Object obj, int row, int col) {
            String colName = this.getColumnName(col);
            Msg.info((Object)((Object)this), (Object)("Set (" + row + "," + col + ") with colName: " + colName + " Value: " + obj.toString()));
            Map mapping = (Map)this.provider.filterTable.getRowObject(row);
            TaintLabel tlabel = (TaintLabel)mapping.get("Taint Label Object");
            switch (colName) {
                case "Selected": {
                    boolean selected = (Boolean)mapping.get(colName);
                    mapping.put(colName, !selected);
                    tlabel.toggle();
                    this.plugin.toggleMarginIcon(tlabel);
                    break;
                }
                case "Label": {
                    String newLabel = (String)obj;
                    mapping.put(colName, newLabel);
                    tlabel.setLabel(newLabel);
                    break;
                }
                default: {
                    Msg.warn((Object)((Object)this), (Object)("Unable to set value at " + colName));
                }
            }
        }

        public TaintLabelsDataFrame getDataFrame() {
            return this.df;
        }

        public Address getAddress(int row) {
            return (Address)((Map)this.getRowObject(row)).get("Address");
        }

        protected void doLoad(Accumulator<Map<String, Object>> accumulator, TaskMonitor monitor) throws CancelledException {
            Msg.info((Object)((Object)this), (Object)"doLoad attempting to load the table.");
            for (Map<String, Object> result : this.df.getData()) {
                Msg.info((Object)((Object)this), (Object)("Loading: " + String.valueOf(result.get("Taint Label Object"))));
                if (monitor.isCancelled()) {
                    monitor.clearCancelled();
                    break;
                }
                accumulator.add(result);
            }
        }

        protected TableColumnDescriptor<Map<String, Object>> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            Iterator<String> iterator = TaintLabelsTableModelFactory.this.sColumns.iterator();
            block14: while (iterator.hasNext()) {
                String columnName;
                switch (columnName = iterator.next()) {
                    case "Address": 
                    case "Function Address": {
                        descriptor.addVisibleColumn((DynamicTableColumn)new AddressColumn(this, columnName));
                        continue block14;
                    }
                    case "Category": 
                    case "Name": {
                        descriptor.addVisibleColumn((DynamicTableColumn)new StringColumn(this, columnName));
                        continue block14;
                    }
                    case "Selected": {
                        descriptor.addVisibleColumn((DynamicTableColumn)new BooleanColumn(this, columnName));
                        continue block14;
                    }
                    case "Taint Label Object": {
                        descriptor.addHiddenColumn((DynamicTableColumn)new TaintLabelColumn(this, columnName));
                        continue block14;
                    }
                }
                descriptor.addVisibleColumn((DynamicTableColumn)new Column(this, columnName));
            }
            return descriptor;
        }

        public class AddressColumn
        extends AbstractDynamicTableColumn<Map<String, Object>, Address, Object> {
            private String name;

            public AddressColumn(TaintLabelsTableModel this$1, String name) {
                this.name = name;
            }

            public String getColumnName() {
                return this.name;
            }

            public Address getValue(Map<String, Object> rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
                return (Address)rowObject.get(this.name);
            }
        }

        public class StringColumn
        extends AbstractDynamicTableColumn<Map<String, Object>, String, Object> {
            private String name;

            public StringColumn(TaintLabelsTableModel this$1, String name) {
                this.name = name;
            }

            public String getColumnName() {
                return this.name;
            }

            public String getValue(Map<String, Object> rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
                Object o = rowObject.get(this.name);
                if (o == null) {
                    return "NULL";
                }
                return o.toString();
            }
        }

        public class BooleanColumn
        extends AbstractDynamicTableColumn<Map<String, Object>, Boolean, Object> {
            private String name;

            public BooleanColumn(TaintLabelsTableModel this$1, String name) {
                this.name = name;
            }

            public String getColumnName() {
                return this.name;
            }

            public Boolean getValue(Map<String, Object> rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
                return (Boolean)rowObject.get(this.name);
            }
        }

        public class TaintLabelColumn
        extends AbstractDynamicTableColumn<Map<String, Object>, TaintLabel, Object> {
            private String columnName;

            public TaintLabelColumn(TaintLabelsTableModel this$1, String name) {
                this.columnName = name;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public TaintLabel getValue(Map<String, Object> rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
                return (TaintLabel)rowObject.get(this.getColumnName());
            }
        }

        public class Column
        extends AbstractDynamicTableColumn<Map<String, Object>, Object, Object> {
            private String columnName;

            public Column(TaintLabelsTableModel this$1, String name) {
                this.columnName = name;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public Object getValue(Map<String, Object> rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
                return rowObject.get(this.getColumnName());
            }
        }

        public class IntegerColumn
        extends AbstractDynamicTableColumn<Map<String, Object>, Integer, Object> {
            private String name;

            public IntegerColumn(TaintLabelsTableModel this$1, String name) {
                this.name = name;
            }

            public String getColumnName() {
                return this.name;
            }

            public Integer getValue(Map<String, Object> rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
                Object o = rowObject.get(this.name);
                if (o == null) {
                    return -1;
                }
                return (Integer)o;
            }
        }

        public class HighVariableColumn
        extends AbstractDynamicTableColumn<Map<String, Object>, HighVariable, Object> {
            private String columnName;

            public HighVariableColumn(TaintLabelsTableModel this$1, String name) {
                this.columnName = name;
            }

            public String getColumnName() {
                return this.columnName;
            }

            public HighVariable getValue(Map<String, Object> rowObject, Settings settings, Object data, ServiceProvider sp) throws IllegalArgumentException {
                return (HighVariable)rowObject.get(this.getColumnName());
            }
        }
    }
}

