/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledUnknown;
import ghidra.app.util.demangler.swift.SwiftDemangledNodeKind;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftProtocolConformanceNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Demangled type = null;
        Demangled protocol = null;
        Demangled namespace = null;
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Module: {
                    namespace = child.demangle(demangler);
                    continue block4;
                }
                case Type: {
                    if (child.hasChild(SwiftDemangledNodeKind.Protocol)) {
                        protocol = child.demangle(demangler);
                        continue block4;
                    }
                    type = child.demangle(demangler);
                    continue block4;
                }
            }
            this.skip(child);
        }
        if (type == null || protocol == null) {
            return this.getUnknown();
        }
        DemangledUnknown demangled = new DemangledUnknown(this.properties.mangled(), this.properties.originalDemangled(), type.getNamespaceString() + "->" + protocol.getNamespaceString());
        demangled.setNamespace(namespace);
        return demangled;
    }
}

