/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SelectionStorage;
import docking.widgets.table.TableFilter;
import docking.widgets.table.WrappingTableModel;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableModelWrapper<ROW_OBJECT>
implements RowObjectFilterModel<ROW_OBJECT>,
SelectionStorage<ROW_OBJECT>,
WrappingTableModel {
    protected List<Integer> filteredIndexList;
    private TableFilter<ROW_OBJECT> tableFilter;
    private RowObjectTableModel<ROW_OBJECT> wrappedModel;
    private List<ROW_OBJECT> lastSelectedObjects = new ArrayList<ROW_OBJECT>();
    private WeakSet<TableModelListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();

    public TableModelWrapper(RowObjectTableModel<ROW_OBJECT> wrappedModel) {
        this.wrappedModel = wrappedModel;
        SystemUtilities.assertTrue((!(wrappedModel instanceof WrappingTableModel) ? 1 : 0) != 0, (String)"Attempted to wrap a table model that has already been wrapped");
        this.filteredIndexList = this.getMatchingFilteredIndices();
        this.copyListeners();
    }

    @Override
    public String getName() {
        return this.wrappedModel.getName();
    }

    @Override
    public List<ROW_OBJECT> getLastSelectedObjects() {
        return this.lastSelectedObjects;
    }

    @Override
    public void setLastSelectedObjects(List<ROW_OBJECT> lastSelectedObjects) {
        this.lastSelectedObjects = lastSelectedObjects;
    }

    @Override
    public void setTableFilter(TableFilter<ROW_OBJECT> tableFilter) {
        this.tableFilter = tableFilter;
        this.updateModel();
    }

    @Override
    public TableFilter<ROW_OBJECT> getTableFilter() {
        return this.tableFilter;
    }

    @Override
    public int getModelRow(int viewRow) {
        if (!this.isFiltered()) {
            return viewRow;
        }
        return this.filteredIndexList.get(viewRow);
    }

    @Override
    public int getViewRow(int modelRow) {
        if (!this.isFiltered()) {
            return modelRow;
        }
        for (int i = 0; i < this.filteredIndexList.size(); ++i) {
            Integer nextModelRow = this.filteredIndexList.get(i);
            if (nextModelRow != modelRow) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void wrappedModelChangedFromTableChangedEvent() {
        this.updateFilterIndices();
    }

    @Override
    public void fireTableChanged(TableModelEvent event) {
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    @Override
    public void fireTableDataChanged() {
        TableModelEvent event = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    private void updateModel() {
        this.updateFilterIndices();
        this.fireTableDataChanged();
    }

    private void copyListeners() {
        TableModelListener[] wrappedListeners;
        if (!(this.wrappedModel instanceof AbstractTableModel)) {
            Msg.warn((Object)this, (Object)"Wrapping a table model that does not give access to listeners.  You should change your base table model implement a known class");
            return;
        }
        AbstractTableModel abstractModel = (AbstractTableModel)((Object)this.wrappedModel);
        for (TableModelListener listener : wrappedListeners = (TableModelListener[])abstractModel.getListeners(TableModelListener.class)) {
            this.addTableModelListener(listener);
        }
    }

    private void updateFilterIndices() {
        this.filteredIndexList = this.getMatchingFilteredIndices();
    }

    private List<Integer> getMatchingFilteredIndices() {
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        int rowCount = this.wrappedModel.getRowCount();
        for (int modelRow = 0; modelRow < rowCount; ++modelRow) {
            if (!this.filterAcceptsRow(modelRow)) continue;
            rowIndexList.add(modelRow);
        }
        return rowIndexList;
    }

    private boolean filterAcceptsRow(int modelRow) {
        if (this.tableFilter == null) {
            return true;
        }
        ROW_OBJECT rowObject = this.wrappedModel.getRowObject(modelRow);
        boolean accepts = this.tableFilter.acceptsRow(rowObject);
        return accepts;
    }

    @Override
    public boolean isFiltered() {
        return this.filteredIndexList.size() != this.wrappedModel.getRowCount();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add((Object)l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove((Object)l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.wrappedModel.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.wrappedModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.wrappedModel.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        if (!this.isFiltered()) {
            return this.wrappedModel.getRowCount();
        }
        return this.filteredIndexList.size();
    }

    @Override
    public int getUnfilteredRowCount() {
        return this.wrappedModel.getRowCount();
    }

    @Override
    public List<ROW_OBJECT> getUnfilteredData() {
        return this.wrappedModel.getModelData();
    }

    @Override
    public List<ROW_OBJECT> getModelData() {
        if (!this.isFiltered()) {
            return this.getUnfilteredData();
        }
        ArrayList<ROW_OBJECT> list = new ArrayList<ROW_OBJECT>();
        int size = this.filteredIndexList.size();
        for (int row = 0; row < size; ++row) {
            Integer modelRowIndex = this.filteredIndexList.get(row);
            list.add(this.wrappedModel.getRowObject(modelRowIndex));
        }
        return list;
    }

    @Override
    public int getModelIndex(ROW_OBJECT t) {
        return this.wrappedModel.getRowIndex(t);
    }

    @Override
    public int getViewIndex(ROW_OBJECT t) {
        int modelRow = this.wrappedModel.getRowIndex(t);
        if (!this.isFiltered()) {
            return modelRow;
        }
        int viewRow = this.getViewRow(modelRow);
        return viewRow;
    }

    @Override
    public int getRowIndex(ROW_OBJECT t) {
        return this.getModelIndex(t);
    }

    @Override
    public ROW_OBJECT getRowObject(int viewRow) {
        if (this.isFiltered()) {
            viewRow = this.filteredIndexList.get(viewRow);
        }
        return this.wrappedModel.getRowObject(viewRow);
    }

    @Override
    public Object getColumnValueForRow(ROW_OBJECT t, int columnIndex) {
        return this.wrappedModel.getColumnValueForRow(t, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.isFiltered()) {
            return this.wrappedModel.getValueAt(rowIndex, columnIndex);
        }
        Integer modelRowIndex = this.filteredIndexList.get(rowIndex);
        return this.wrappedModel.getValueAt(modelRowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isFiltered()) {
            return this.wrappedModel.isCellEditable(rowIndex, columnIndex);
        }
        Integer modelRowIndex = this.filteredIndexList.get(rowIndex);
        return this.wrappedModel.isCellEditable(modelRowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (!this.isFiltered()) {
            this.wrappedModel.setValueAt(value, rowIndex, columnIndex);
            return;
        }
        Integer modelRowIndex = this.filteredIndexList.get(rowIndex);
        this.wrappedModel.setValueAt(value, modelRowIndex, columnIndex);
    }

    @Override
    public TableModel getWrappedModel() {
        return this.wrappedModel;
    }
}

