/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexTypeOrMethodDef;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableGenericParam
extends CliAbstractTable {
    public CliTableGenericParam(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliGenericParamRow row = new CliGenericParamRow(reader.readNextShort(), reader.readNextShort(), CliIndexTypeOrMethodDef.readCodedIndex(reader, stream), this.readStringIndex(reader));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "GenericParam Row", 0);
        rowDt.add(WORD, "Number", "index of the generic param, numbered left-to-right, from 0");
        rowDt.add((DataType)CliFlags.CliEnumGenericParamAttributes.dataType, "Flags", "Bitmask of type GenericParamAttributes");
        rowDt.add(CliIndexTypeOrMethodDef.toDataType(this.metadataStream), "Owner", "TypeOrMethodDef coded index");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap, for description only");
        return rowDt;
    }

    public class CliGenericParamRow
    extends CliAbstractTableRow {
        public short number;
        public short flags;
        public int ownerIndex;
        public int nameIndex;

        public CliGenericParamRow(short number, short flags, int ownerIndex, int nameIndex) {
            this.number = number;
            this.flags = flags;
            this.ownerIndex = ownerIndex;
            this.nameIndex = nameIndex;
        }

        @Override
        public String getRepresentation() {
            String ownerRep;
            try {
                ownerRep = CliTableGenericParam.this.getRowRepresentationSafe(CliIndexTypeOrMethodDef.getTableName(this.ownerIndex), CliIndexTypeOrMethodDef.getRowIndex(this.ownerIndex));
            }
            catch (InvalidInputException e) {
                ownerRep = Integer.toHexString(this.ownerIndex);
            }
            return String.format("%s Owner %s Number %d Flags %s", CliTableGenericParam.this.metadataStream.getStringsStream().getString(this.nameIndex), ownerRep, this.number, CliFlags.CliEnumGenericParamAttributes.dataType.getName(this.flags & 0xFFFF));
        }
    }
}

