/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.expression;

import ghidra.app.util.bin.format.dwarf.DWARFRegisterMappings;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOperandType;
import ghidra.program.model.lang.Register;
import java.util.Arrays;

public enum DWARFExpressionOpCode {
    DW_OP_unknown_opcode(0),
    DW_OP_addr(3, DWARFExpressionOperandType.ADDR),
    DW_OP_deref(6),
    DW_OP_const1u(8, DWARFExpressionOperandType.U_BYTE),
    DW_OP_const1s(9, DWARFExpressionOperandType.S_BYTE),
    DW_OP_const2u(10, DWARFExpressionOperandType.U_SHORT),
    DW_OP_const2s(11, DWARFExpressionOperandType.S_SHORT),
    DW_OP_const4u(12, DWARFExpressionOperandType.U_INT),
    DW_OP_const4s(13, DWARFExpressionOperandType.S_INT),
    DW_OP_const8u(14, DWARFExpressionOperandType.U_LONG),
    DW_OP_const8s(15, DWARFExpressionOperandType.S_LONG),
    DW_OP_constu(16, DWARFExpressionOperandType.U_LEB128),
    DW_OP_consts(17, DWARFExpressionOperandType.S_LEB128),
    DW_OP_dup(18),
    DW_OP_drop(19),
    DW_OP_over(20),
    DW_OP_pick(21, DWARFExpressionOperandType.U_BYTE),
    DW_OP_swap(22),
    DW_OP_rot(23),
    DW_OP_xderef(24),
    DW_OP_abs(25),
    DW_OP_and(26),
    DW_OP_div(27),
    DW_OP_minus(28),
    DW_OP_mod(29),
    DW_OP_mul(30),
    DW_OP_neg(31),
    DW_OP_not(32),
    DW_OP_or(33),
    DW_OP_plus(34),
    DW_OP_plus_uconst(35, DWARFExpressionOperandType.U_LEB128),
    DW_OP_shl(36),
    DW_OP_shr(37),
    DW_OP_shra(38),
    DW_OP_xor(39),
    DW_OP_bra(40, DWARFExpressionOperandType.S_SHORT),
    DW_OP_eq(41),
    DW_OP_ge(42),
    DW_OP_gt(43),
    DW_OP_le(44),
    DW_OP_lt(45),
    DW_OP_ne(46),
    DW_OP_skip(47, DWARFExpressionOperandType.S_SHORT),
    DW_OP_lit0(48),
    DW_OP_lit1(49),
    DW_OP_lit2(50),
    DW_OP_lit3(51),
    DW_OP_lit4(52),
    DW_OP_lit5(53),
    DW_OP_lit6(54),
    DW_OP_lit7(55),
    DW_OP_lit8(56),
    DW_OP_lit9(57),
    DW_OP_lit10(58),
    DW_OP_lit11(59),
    DW_OP_lit12(60),
    DW_OP_lit13(61),
    DW_OP_lit14(62),
    DW_OP_lit15(63),
    DW_OP_lit16(64),
    DW_OP_lit17(65),
    DW_OP_lit18(66),
    DW_OP_lit19(67),
    DW_OP_lit20(68),
    DW_OP_lit21(69),
    DW_OP_lit22(70),
    DW_OP_lit23(71),
    DW_OP_lit24(72),
    DW_OP_lit25(73),
    DW_OP_lit26(74),
    DW_OP_lit27(75),
    DW_OP_lit28(76),
    DW_OP_lit29(77),
    DW_OP_lit30(78),
    DW_OP_lit31(79),
    DW_OP_reg0(80),
    DW_OP_reg1(81),
    DW_OP_reg2(82),
    DW_OP_reg3(83),
    DW_OP_reg4(84),
    DW_OP_reg5(85),
    DW_OP_reg6(86),
    DW_OP_reg7(87),
    DW_OP_reg8(88),
    DW_OP_reg9(89),
    DW_OP_reg10(90),
    DW_OP_reg11(91),
    DW_OP_reg12(92),
    DW_OP_reg13(93),
    DW_OP_reg14(94),
    DW_OP_reg15(95),
    DW_OP_reg16(96),
    DW_OP_reg17(97),
    DW_OP_reg18(98),
    DW_OP_reg19(99),
    DW_OP_reg20(100),
    DW_OP_reg21(101),
    DW_OP_reg22(102),
    DW_OP_reg23(103),
    DW_OP_reg24(104),
    DW_OP_reg25(105),
    DW_OP_reg26(106),
    DW_OP_reg27(107),
    DW_OP_reg28(108),
    DW_OP_reg29(109),
    DW_OP_reg30(110),
    DW_OP_reg31(111),
    DW_OP_breg0(112, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg1(113, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg2(114, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg3(115, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg4(116, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg5(117, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg6(118, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg7(119, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg8(120, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg9(121, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg10(122, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg11(123, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg12(124, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg13(125, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg14(126, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg15(127, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg16(128, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg17(129, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg18(130, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg19(131, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg20(132, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg21(133, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg22(134, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg23(135, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg24(136, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg25(137, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg26(138, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg27(139, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg28(140, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg29(141, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg30(142, DWARFExpressionOperandType.S_LEB128),
    DW_OP_breg31(143, DWARFExpressionOperandType.S_LEB128),
    DW_OP_regx(144, DWARFExpressionOperandType.U_LEB128),
    DW_OP_fbreg(145, DWARFExpressionOperandType.S_LEB128),
    DW_OP_bregx(146, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.S_LEB128),
    DW_OP_piece(147, DWARFExpressionOperandType.U_LEB128),
    DW_OP_deref_size(148, DWARFExpressionOperandType.U_BYTE),
    DW_OP_xderef_size(149, DWARFExpressionOperandType.U_BYTE),
    DW_OP_nop(150),
    DW_OP_push_object_address(151),
    DW_OP_call2(152, DWARFExpressionOperandType.U_SHORT),
    DW_OP_call4(153, DWARFExpressionOperandType.U_INT),
    DW_OP_call_ref(154, DWARFExpressionOperandType.DWARF_INT),
    DW_OP_form_tls_address(155),
    DW_OP_call_frame_cfa(156),
    DW_OP_bit_piece(157, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.U_LEB128),
    DW_OP_implicit_value(158, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.SIZED_BLOB),
    DW_OP_stack_value(159),
    DW_OP_implicit_pointer(160, DWARFExpressionOperandType.DWARF_INT, DWARFExpressionOperandType.S_LEB128),
    DW_OP_addrx(161, DWARFExpressionOperandType.U_LEB128),
    DW_OP_constx(162, DWARFExpressionOperandType.U_LEB128),
    DW_OP_entry_value(163, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.SIZED_BLOB),
    DW_OP_const_type(164, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.U_BYTE, DWARFExpressionOperandType.SIZED_BLOB),
    DW_OP_regval_type(165, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.U_LEB128),
    DW_OP_deref_type(166, DWARFExpressionOperandType.U_BYTE, DWARFExpressionOperandType.U_LEB128),
    DW_OP_xderef_type(167, DWARFExpressionOperandType.U_BYTE, DWARFExpressionOperandType.U_LEB128),
    DW_OP_convert(168, DWARFExpressionOperandType.U_LEB128),
    DW_OP_reinterpret(169, DWARFExpressionOperandType.U_LEB128);

    private static final int DW_OP_lo_user = 224;
    private static final int DW_OP_hi_user = 255;
    private final int opcode;
    private final DWARFExpressionOperandType[] operandTypes;
    private static DWARFExpressionOpCode[] lookupvals;
    private static int[] opcodes;

    private DWARFExpressionOpCode(int opcode) {
        this.opcode = opcode;
        this.operandTypes = DWARFExpressionOperandType.EMPTY_TYPELIST;
    }

    private DWARFExpressionOpCode(int opcode, DWARFExpressionOperandType ... operandTypes) {
        this.opcode = opcode;
        this.operandTypes = operandTypes;
    }

    public byte getOpCodeValue() {
        return (byte)this.opcode;
    }

    public DWARFExpressionOperandType[] getOperandTypes() {
        return this.operandTypes;
    }

    private static int[] getAllOpcodes() {
        int[] results = new int[lookupvals.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = DWARFExpressionOpCode.lookupvals[i].opcode;
        }
        return results;
    }

    public static boolean isInRange(DWARFExpressionOpCode op, DWARFExpressionOpCode lo, DWARFExpressionOpCode hi) {
        return lo.opcode <= op.opcode && op.opcode <= hi.opcode;
    }

    public int getRelativeOpCodeOffset(DWARFExpressionOpCode baseOp) {
        return this.opcode - baseOp.opcode;
    }

    public String toString(DWARFRegisterMappings regMapping) {
        int regIdx = -1;
        if (DWARFExpressionOpCode.isInRange(this, DW_OP_reg0, DW_OP_reg31)) {
            regIdx = this.getRelativeOpCodeOffset(DW_OP_reg0);
        } else if (DWARFExpressionOpCode.isInRange(this, DW_OP_breg0, DW_OP_breg31)) {
            regIdx = this.getRelativeOpCodeOffset(DW_OP_breg0);
        }
        Register reg = regIdx >= 0 && regMapping != null ? regMapping.getGhidraReg(regIdx) : null;
        return this.toString() + (String)(reg != null ? "(" + reg.getName() + ")" : "");
    }

    public static DWARFExpressionOpCode parse(int opcode) {
        int opcodeIdx = Arrays.binarySearch(opcodes, opcode);
        return opcodeIdx >= 0 ? lookupvals[opcodeIdx] : null;
    }

    static {
        lookupvals = DWARFExpressionOpCode.values();
        opcodes = DWARFExpressionOpCode.getAllOpcodes();
    }
}

