/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.attribs;

import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.util.NumericUtilities;

public class DWARFBlobAttribute
extends DWARFAttributeValue {
    private final byte[] bytes;

    public DWARFBlobAttribute(byte[] bytes, DWARFAttributeDef<?> def) {
        super(def);
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.bytes.length;
    }

    @Override
    public String getValueString(DWARFCompilationUnit cu) {
        return NumericUtilities.convertBytesToString((byte[])this.bytes, (String)" ");
    }

    public String toString() {
        return "%s : %s = [%d]%s".formatted(new Object[]{this.getAttributeName(), this.getAttributeForm(), this.bytes.length, NumericUtilities.convertBytesToString((byte[])this.bytes, (String)" ")});
    }
}

