/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.ComponentProvider;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreePanel;
import ghidra.app.plugin.core.programtree.TreeViewProvider;
import ghidra.app.plugin.core.programtree.ViewManagerComponentProvider;
import ghidra.app.plugin.core.programtree.ViewPanel;
import ghidra.app.plugin.core.programtree.ViewProviderService;
import ghidra.program.model.listing.Program;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ProgramTreeActionContext
extends ProgramActionContext {
    private ViewManagerComponentProvider provider;

    public ProgramTreeActionContext(ViewManagerComponentProvider provider, Program program, ViewPanel viewPanel, Object contextObject) {
        super((ComponentProvider)provider, program, viewPanel, contextObject);
        this.provider = provider;
    }

    public ProgramDnDTree getTree() {
        ViewProviderService viewProvider = this.provider.getCurrentViewProvider();
        if (!(viewProvider instanceof TreeViewProvider)) {
            return null;
        }
        TreeViewProvider treeProvider = (TreeViewProvider)viewProvider;
        ProgramTreePanel treePanel = treeProvider.getViewComponent();
        return treePanel.getDnDTree();
    }

    public TreePath[] getSelectionPaths() {
        ProgramDnDTree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        return tree.getSelectionPaths();
    }

    public ProgramNode getLeadSelectedNode() {
        ProgramNode node = this.getSingleSelectedNode();
        if (node != null) {
            return node;
        }
        ProgramDnDTree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        int n = tree.getSelectionCount();
        if (n == 0) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (n > 1) {
            path = tree.getLeadSelectionPath();
        }
        return (ProgramNode)path.getLastPathComponent();
    }

    public ProgramNode getSingleSelectedNode() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return null;
        }
        return (ProgramNode)paths[0].getLastPathComponent();
    }

    public boolean hasSingleNodeSelection() {
        ProgramDnDTree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        return tree.getSelectionCount() == 1;
    }

    public boolean isOnlyRootNodeSelected() {
        DefaultTreeModel treeModel;
        ProgramNode root;
        ProgramDnDTree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return false;
        }
        ProgramNode node = (ProgramNode)paths[0].getLastPathComponent();
        return node == (root = (ProgramNode)(treeModel = (DefaultTreeModel)tree.getModel()).getRoot());
    }

    public boolean hasFullNodeMultiSelection() {
        ProgramDnDTree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        ProgramNode root = (ProgramNode)treeModel.getRoot();
        for (TreePath path : paths) {
            ProgramNode node = (ProgramNode)path.getLastPathComponent();
            if (node == root) {
                return false;
            }
            if (!this.hasMixedChildSelection(node, paths)) continue;
            return false;
        }
        return true;
    }

    private boolean hasMixedChildSelection(ProgramNode node, TreePath[] selectedPaths) {
        if (!node.getAllowsChildren()) {
            return false;
        }
        int nchild = node.getChildCount();
        int numberSelected = 0;
        block0: for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            TreePath childPath = child.getTreePath();
            for (TreePath element : selectedPaths) {
                if (!childPath.equals(element)) continue;
                ++numberSelected;
                continue block0;
            }
        }
        return numberSelected != 0 && numberSelected != nchild;
    }
}

