/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.dnd.GClipboard;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreeActionManager;
import ghidra.app.plugin.core.programtree.ProgramTreeTransferable;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.tree.TreePath;

class PasteManager {
    private ProgramTreeActionManager actionManager;
    private String lastGroupPasted;

    PasteManager(ProgramTreeActionManager actionManager) {
        this.actionManager = actionManager;
    }

    boolean isPasteAllowed(ProgramNode destNode, ProgramNode pasteNode, boolean isCutOperation) {
        if (destNode.getProgram() != pasteNode.getProgram() || destNode.getRoot() != pasteNode.getRoot()) {
            return false;
        }
        if (destNode.getName().equals(pasteNode.getName())) {
            return false;
        }
        if (destNode.isNodeAncestor(pasteNode)) {
            return false;
        }
        if (destNode.isFragment() && pasteNode.isModule()) {
            return isCutOperation && !pasteNode.getModule().isDescendant(destNode.getFragment());
        }
        if (destNode.isFragment() && pasteNode.isFragment()) {
            return isCutOperation;
        }
        if (destNode.isModule()) {
            ProgramModule destModule = destNode.getModule();
            if (pasteNode.isModule()) {
                if (pasteNode.getModule().isDescendant(destModule)) {
                    return false;
                }
                if (!isCutOperation && destModule.contains(pasteNode.getModule())) {
                    return false;
                }
            } else if (!isCutOperation && destModule.contains(pasteNode.getFragment())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paste(ProgramDnDTree tree, ProgramNode destNode) {
        int transactionID = tree.startTransaction("Paste");
        if (transactionID < 0) {
            return;
        }
        TreePath path = destNode.getTreePath();
        Clipboard systemClipboard = GClipboard.getSystemClipboard();
        Transferable t = systemClipboard.getContents(tree);
        try {
            if (t == null || !t.isDataFlavorSupported(ProgramTreeTransferable.localTreeNodeFlavor)) {
                return;
            }
            tree.setBusyCursor(true);
            this.lastGroupPasted = null;
            List list = (List)t.getTransferData(ProgramTreeTransferable.localTreeNodeFlavor);
            if (list == null) {
                return;
            }
            for (ProgramNode node : list) {
                if (destNode.getRoot() != node.getRoot()) {
                    this.lastGroupPasted = null;
                    break;
                }
                if (destNode.getName().equals(node.getName()) || !this.pasteGroup(tree, destNode, node) || destNode.isFragment() && node.isModule()) continue;
                this.lastGroupPasted = node.getName();
            }
            if (this.lastGroupPasted == null) {
                tree.setBusyCursor(false);
            }
            this.actionManager.cutClipboardNodes(tree);
            tree.removeSelectionPath(path);
            tree.addSelectionPath(path);
        }
        catch (UnsupportedFlavorException e) {
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)"Data flavor in clipboard is not supported.", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Unexpected Exception Pasting", (Object)"Unexpected exception pasting nodes", (Throwable)e);
        }
        finally {
            tree.endTransaction(transactionID, true);
        }
    }

    String getLastGroupPasted() {
        return this.lastGroupPasted;
    }

    private boolean pasteGroup(ProgramDnDTree tree, ProgramNode destNode, ProgramNode nodeToPaste) {
        if (destNode.isFragment()) {
            try {
                tree.mergeGroup(nodeToPaste.getGroup(), destNode.getFragment());
                this.actionManager.removeFromClipboard(tree, nodeToPaste);
                return true;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (Exception e) {
                Msg.showError((Object)this, null, null, (Object)"Error Merging Fragments", (Throwable)e);
            }
            return false;
        }
        ProgramModule targetModule = destNode.getModule();
        if (targetModule == null) {
            this.actionManager.clearCut(nodeToPaste);
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)("Paste of " + String.valueOf(nodeToPaste) + " at\n" + destNode.getName() + " is not allowed."));
            return false;
        }
        return this.pasteNode(tree, destNode, nodeToPaste);
    }

    private boolean pasteNode(ProgramDnDTree tree, ProgramNode destNode, ProgramNode nodeToPaste) {
        ProgramModule targetModule = destNode.getModule();
        ProgramModule module = nodeToPaste.getModule();
        ProgramFragment fragment = nodeToPaste.getFragment();
        if (module == null && fragment == null) {
            this.actionManager.clearCut(nodeToPaste);
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)("Could not paste " + String.valueOf(nodeToPaste) + " at " + targetModule.getName()));
            return false;
        }
        boolean pasteOK = false;
        try {
            ProgramNode newnode;
            pasteOK = module != null ? this.pasteModule(tree, destNode, nodeToPaste, targetModule, module) : this.pasteFragment(tree, nodeToPaste, targetModule, fragment);
            if (tree.isExpanded(destNode.getTreePath()) && (newnode = tree.getChild(destNode, nodeToPaste.getName())) != null) {
                tree.matchExpansionState(nodeToPaste, newnode);
            }
            return pasteOK;
        }
        catch (CircularDependencyException e) {
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)e.getMessage());
        }
        catch (DuplicateGroupException e) {
        }
        catch (NotFoundException e) {
            Msg.showError((Object)this, null, (String)"Paste from Clipboard Failed", (Object)e.getMessage());
        }
        this.removeFromClipboard(tree, nodeToPaste);
        return false;
    }

    private boolean pasteFragment(ProgramDnDTree tree, ProgramNode nodeToPaste, ProgramModule targetModule, ProgramFragment fragment) throws NotFoundException, DuplicateGroupException {
        boolean pasteOK = false;
        if (targetModule.contains(fragment)) {
            if (targetModule.equals((Object)nodeToPaste.getParentModule())) {
                this.removeFromClipboard(tree, nodeToPaste);
            }
        } else if (this.actionManager.clipboardContains(nodeToPaste)) {
            targetModule.reparent(nodeToPaste.getName(), nodeToPaste.getParentModule());
            this.removeFromClipboard(tree, nodeToPaste);
            pasteOK = true;
        } else {
            targetModule.add(fragment);
            pasteOK = true;
        }
        return pasteOK;
    }

    private boolean pasteModule(ProgramDnDTree tree, ProgramNode destNode, ProgramNode nodeToPaste, ProgramModule targetModule, ProgramModule module) throws NotFoundException, CircularDependencyException, DuplicateGroupException {
        boolean pasteOK = false;
        if (!destNode.wasVisited()) {
            tree.visitNode(destNode);
        }
        if (targetModule.contains(module)) {
            if (targetModule.equals((Object)nodeToPaste.getParentModule())) {
                this.removeFromClipboard(tree, nodeToPaste);
            }
        } else if (this.actionManager.clipboardContains(nodeToPaste)) {
            targetModule.reparent(nodeToPaste.getName(), nodeToPaste.getParentModule());
            this.removeFromClipboard(tree, nodeToPaste);
            pasteOK = true;
        } else {
            targetModule.add(module);
            pasteOK = true;
        }
        if (pasteOK && tree.isExpanded(destNode.getTreePath())) {
            tree.groupAdded((Group)module);
        }
        return pasteOK;
    }

    private void removeFromClipboard(ProgramDnDTree tree, ProgramNode node) {
        this.actionManager.removeFromClipboard(tree, node);
        this.actionManager.clearCut(node);
    }
}

