/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.nav;

import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.util.ProgramSelection;

public abstract class NextRangeAction
extends NavigatableContextAction {
    private PluginTool tool;
    private NavigationOptions navOptions;

    public NextRangeAction(PluginTool tool, String name, String owner, NavigationOptions navOptions) {
        super(name, owner);
        this.tool = tool;
        this.navOptions = navOptions;
        this.setEnabled(false);
        this.addToWindowWhen(NavigatableActionContext.class);
    }

    @Override
    public boolean isEnabledForContext(NavigatableActionContext context) {
        Address currentAddress = context.getAddress();
        ProgramSelection selection = this.getSelection(context);
        if (selection == null || selection.isEmpty() || currentAddress == null) {
            return false;
        }
        CodeUnit cu = context.getProgram().getListing().getCodeUnitAt(currentAddress);
        if (cu != null) {
            currentAddress = cu.getMaxAddress();
        }
        AddressRange lastRange = selection.getLastRange();
        Address maxAddress = this.navOptions.isGotoTopAndBottomOfRangeEnabled() ? lastRange.getMaxAddress() : lastRange.getMinAddress();
        return currentAddress.compareTo((Object)maxAddress) < 0;
    }

    @Override
    public void actionPerformed(NavigatableActionContext context) {
        Address goToAddress = this.getGoToAddress(context);
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            service.goTo(context.getNavigatable(), goToAddress);
        }
    }

    private Address getGoToAddress(ProgramLocationActionContext context) {
        AddressRangeIterator it;
        Address currentAddress;
        ProgramSelection selection = this.getSelection(context);
        Address maxAddress = currentAddress = context.getAddress();
        CodeUnit cu = context.getCodeUnit();
        if (cu != null) {
            maxAddress = cu.getMaxAddress();
        }
        if (!(it = selection.getAddressRanges(currentAddress, true)).hasNext()) {
            return currentAddress;
        }
        AddressRange range = (AddressRange)it.next();
        if (range.contains(currentAddress)) {
            if (this.navOptions.isGotoTopAndBottomOfRangeEnabled() && !currentAddress.equals((Object)range.getMaxAddress()) && !maxAddress.equals((Object)range.getMaxAddress())) {
                return range.getMaxAddress();
            }
            if (!it.hasNext()) {
                return currentAddress;
            }
            range = (AddressRange)it.next();
        }
        return range.getMinAddress();
    }

    protected abstract ProgramSelection getSelection(ProgramLocationActionContext var1);
}

