/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.register;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.Msg;
import java.math.BigInteger;

public class SetRegisterCmd
implements Command<Program> {
    private Register register;
    private Address start;
    private Address end;
    private BigInteger value;
    private String errorMsg;

    public SetRegisterCmd(Register register, Address start, Address end, BigInteger value) {
        if (!start.getAddressSpace().equals((Object)end.getAddressSpace())) {
            throw new IllegalArgumentException("start and end address must be within the same address space");
        }
        this.register = register;
        this.start = start;
        this.end = end;
        this.value = value;
    }

    public boolean applyTo(Program program) {
        ProgramContext context = program.getProgramContext();
        try {
            context.setValue(this.register, this.start, this.end, this.value);
        }
        catch (ContextChangeException e) {
            this.errorMsg = e.getMessage();
            Msg.error((Object)this, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }

    public String getName() {
        return "Set Register Value";
    }
}

