/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntUnOpGen;
import ghidra.pcode.emu.jit.op.JitLzCountOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public enum LzCountOpGen implements IntUnOpGen<JitLzCountOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return false;
    }

    private void generateMpIntLzCount(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        mv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "numberOfLeadingZeros", GenConsts.MDESC_INTEGER__NUMBER_OF_LEADING_ZEROS, false);
        for (int i = 1; i < type.legsAlloc(); ++i) {
            mv.visitInsn(95);
            mv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "numberOfLeadingZeros", GenConsts.MDESC_INTEGER__NUMBER_OF_LEADING_ZEROS, false);
            Label lblAdd = new Label();
            Label lblNext = new Label();
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)32);
            mv.visitJumpInsn(159, lblAdd);
            mv.visitInsn(95);
            mv.visitInsn(87);
            mv.visitJumpInsn(167, lblNext);
            mv.visitLabel(lblAdd);
            mv.visitInsn(96);
            mv.visitLabel(lblNext);
        }
        JitType.SimpleJitType mslType = type.legTypes().get(0);
        if (mslType.size() < 4) {
            mv.visitLdcInsn((Object)(32 - mslType.size() * 8));
            mv.visitInsn(100);
        }
    }

    @Override
    public JitType generateUnOpRunCode(JitCodeGenerator gen, JitLzCountOp op, JitControlFlowModel.JitBlock block, JitType uType, MethodVisitor rv) {
        JitType jitType = uType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.IntJitType t = (JitType.IntJitType)jitType2;
                rv.visitMethodInsn(184, GenConsts.NAME_INTEGER, "numberOfLeadingZeros", GenConsts.MDESC_INTEGER__NUMBER_OF_LEADING_ZEROS, false);
                if (t.size() >= 4) break;
                rv.visitLdcInsn((Object)(32 - t.size() * 8));
                rv.visitInsn(100);
                break;
            }
            case 1: {
                JitType.LongJitType t = (JitType.LongJitType)jitType2;
                rv.visitMethodInsn(184, GenConsts.NAME_LONG, "numberOfLeadingZeros", GenConsts.MDESC_LONG__NUMBER_OF_LEADING_ZEROS, false);
                if (t.size() >= 8) break;
                rv.visitLdcInsn((Object)(64 - t.size() * 8));
                rv.visitInsn(100);
                break;
            }
            case 2: {
                JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                this.generateMpIntLzCount(gen, t, rv);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return JitType.IntJitType.I4;
    }
}

