/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.BranchOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitBranchIndOp;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.RegisterValue;
import org.objectweb.asm.MethodVisitor;

public enum BranchIndOpGen implements OpGen<JitBranchIndOp>
{
    GEN;


    static void generateExitCode(JitCodeGenerator gen, JitBranchIndOp op, RegisterValue ctx, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        gen.generatePassageExit(block, () -> {
            JitType targetType = gen.generateValReadCode(op.target(), op.targetType(), TypeConversions.Ext.ZERO);
            TypeConversions.generateToLong(targetType, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, rv);
        }, ctx, rv);
        rv.visitInsn(1);
        rv.visitInsn(176);
    }

    @Override
    public void generateRunCode(JitCodeGenerator gen, JitBranchIndOp op, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
        IndBranchGen.IND.generateCode(gen, op, op.branch(), block, rv);
    }

    static class IndBranchGen
    extends BranchOpGen.BranchGen<JitPassage.RIndBranch, JitBranchIndOp> {
        static final IndBranchGen IND = new IndBranchGen();

        IndBranchGen() {
        }

        @Override
        Address exit(JitCodeGenerator gen, JitPassage.RIndBranch branch) {
            return null;
        }

        @Override
        void generateCodeWithoutCtxmod(JitCodeGenerator gen, JitBranchIndOp op, JitPassage.RIndBranch branch, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            BranchIndOpGen.generateExitCode(gen, op, branch.flowCtx(), block, rv);
        }

        @Override
        void generateCodeWithCtxmod(JitCodeGenerator gen, JitBranchIndOp op, Address exit, JitControlFlowModel.JitBlock block, MethodVisitor rv) {
            BranchIndOpGen.generateExitCode(gen, op, null, block, rv);
        }
    }
}

