/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.gen.FieldForContext;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.InstanceFieldReq;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public record FieldForExitSlot(JitPassage.AddrCtx target) implements InstanceFieldReq
{
    @Override
    public String name() {
        return "exit_%x_%s".formatted(this.target.address.getOffset(), this.target.biCtx.toString(16));
    }

    @Override
    public void generateInitCode(JitCodeGenerator gen, ClassVisitor cv, MethodVisitor iv) {
        FieldForContext ctxField = gen.requestStaticFieldForContext(this.target.rvCtx);
        cv.visitField(18, this.name(), GenConsts.TDESC_EXIT_SLOT, null, null);
        JitAllocationModel.InitFixedLocal.THIS.generateLoadCode(iv);
        iv.visitInsn(89);
        iv.visitLdcInsn((Object)this.target.address.getOffset());
        ctxField.generateLoadCode(gen, iv);
        iv.visitMethodInsn(185, GenConsts.NAME_JIT_COMPILED_PASSAGE, "createExitSlot", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CREATE_EXIT_SLOT, true);
        iv.visitFieldInsn(181, gen.nameThis, this.name(), GenConsts.TDESC_EXIT_SLOT);
    }

    @Override
    public void generateLoadCode(JitCodeGenerator gen, MethodVisitor rv) {
        JitAllocationModel.RunFixedLocal.THIS.generateLoadCode(rv);
        rv.visitFieldInsn(180, gen.nameThis, this.name(), GenConsts.TDESC_EXIT_SLOT);
    }
}

