/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.op.JitCatenateOp;
import ghidra.pcode.emu.jit.op.JitDefOp;
import ghidra.pcode.emu.jit.op.JitPhiOp;
import ghidra.pcode.emu.jit.var.JitConstVal;
import ghidra.pcode.emu.jit.var.JitMissingVar;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SequencedSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;

public class JitDataFlowState
implements PcodeExecutorState<JitVal> {
    private final JitDataFlowModel dfm;
    private final JitControlFlowModel.JitBlock block;
    private final Language language;
    private final JitDataFlowArithmetic arithmetic;
    private final MiniDFState mini = new MiniDFState();
    private final Set<Varnode> varnodesRead = new HashSet<Varnode>();
    private final Set<Varnode> varnodesWritten = new HashSet<Varnode>();

    JitDataFlowState(JitAnalysisContext context, JitDataFlowModel dfm, JitControlFlowModel.JitBlock block) {
        this.dfm = dfm;
        this.block = block;
        this.language = context.getLanguage();
        this.arithmetic = dfm.getArithmetic();
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    public JitDataFlowArithmetic getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
        return Stream.of(this);
    }

    @Override
    public void setVar(AddressSpace space, JitVal offset, int size, boolean quantize, JitVal val) {
        if (space.isConstantSpace()) {
            Msg.warn((Object)this, (Object)"Witnessed write to constant space! Ignoring.");
            return;
        }
        if (!(offset instanceof JitConstVal)) {
            return;
        }
        JitConstVal c = (JitConstVal)offset;
        Varnode varnode = new Varnode(space.getAddress(c.value().longValue()), size);
        this.varnodesWritten.add(varnode);
        this.mini.set(varnode, val);
    }

    @Override
    public void setVarInternal(AddressSpace space, JitVal offset, int size, JitVal val) {
        this.setVar(space, offset, size, false, val);
    }

    public List<JitVal> getDefinitions(Varnode varnode) {
        return this.mini.getDefinitions(varnode);
    }

    public List<JitVal> getDefinitions(Register register) {
        return this.mini.getDefinitions(register);
    }

    List<JitVal> generatePhis(List<JitVal> defs, SequencedSet<JitPhiOp> phiQueue) {
        return this.mini.generatePhis(defs, phiQueue);
    }

    @Override
    public JitVal getVar(AddressSpace space, JitVal offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        if (space.isConstantSpace()) {
            if (!(offset instanceof JitConstVal)) {
                throw new AssertionError((Object)"Non-constant constant?");
            }
            JitConstVal c = (JitConstVal)offset;
            if (c.size() == size) {
                return offset;
            }
            return new JitConstVal(size, c.value());
        }
        if (space.isMemorySpace()) {
            if (offset instanceof JitConstVal) {
                JitConstVal c = (JitConstVal)offset;
                Varnode vn = new Varnode(space.getAddress(c.value().longValue()), size);
                return this.dfm.generateDirectMemoryVar(vn);
            }
            return this.dfm.generateIndirectMemoryVar(space, offset, size, quantize);
        }
        if (!(offset instanceof JitConstVal)) {
            throw new AssertionError((Object)"Indirect non-memory access?");
        }
        JitConstVal c = (JitConstVal)offset;
        Varnode varnode = new Varnode(space.getAddress(c.value().longValue()), size);
        this.varnodesRead.add(varnode);
        return this.mini.getVar(varnode);
    }

    @Override
    public JitVal getVarInternal(AddressSpace space, JitVal offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return this.getVar(space, offset, size, false, reason);
    }

    @Override
    public Map<Register, JitVal> getRegisterValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PcodeExecutorState<JitVal> fork(PcodeStateCallbacks cb) {
        throw new UnsupportedOperationException();
    }

    public Set<Varnode> getVarnodesRead() {
        return this.varnodesRead;
    }

    public Set<Varnode> getVarnodesWritten() {
        return this.varnodesWritten;
    }

    public MiniDFState captureState() {
        return this.mini.copy();
    }

    public class MiniDFState {
        private final NavigableMap<Long, JitVal> uniqMap;
        private final NavigableMap<Long, JitVal> regMap;

        MiniDFState() {
            this(new TreeMap<Long, JitVal>(), new TreeMap<Long, JitVal>());
        }

        MiniDFState(NavigableMap<Long, JitVal> uniqMap, NavigableMap<Long, JitVal> regMap) {
            this.uniqMap = uniqMap;
            this.regMap = regMap;
        }

        NavigableMap<Long, JitVal> mapFor(AddressSpace space) {
            if (space.isUniqueSpace()) {
                return this.uniqMap;
            }
            if (space.isRegisterSpace()) {
                return this.regMap;
            }
            return null;
        }

        protected static long endOf(Map.Entry<Long, JitVal> entry) {
            return entry.getKey() + (long)entry.getValue().size();
        }

        protected void doClear(NavigableMap<Long, JitVal> map, Varnode varnode) {
            JitVal truncVal;
            Varnode truncVn;
            JitVal entVal;
            int shave;
            long entStart;
            long end;
            Map.Entry<Long, JitVal> truncRightEntry;
            AddressSpace space = varnode.getAddress().getAddressSpace();
            long offset = varnode.getOffset();
            int size = varnode.getSize();
            Map.Entry<Long, JitVal> truncLeftEntry = map.lowerEntry(offset);
            if (truncLeftEntry != null && MiniDFState.endOf(truncLeftEntry) <= offset) {
                truncLeftEntry = null;
            }
            if ((truncRightEntry = map.lowerEntry(end = offset + (long)size)) != null && MiniDFState.endOf(truncRightEntry) <= end) {
                truncRightEntry = null;
            }
            if (truncRightEntry != null) {
                entStart = truncRightEntry.getKey();
                map.remove(entStart);
                shave = (int)(MiniDFState.endOf(truncRightEntry) - end);
                entVal = truncRightEntry.getValue();
                truncVn = new Varnode(space.getAddress(entStart), entVal.size());
                truncVal = JitDataFlowState.this.arithmetic.truncFromLeft(truncVn, shave, entVal);
                map.put(end, truncVal);
            }
            if (truncLeftEntry != null) {
                entStart = truncLeftEntry.getKey();
                map.remove(entStart);
                shave = (int)(MiniDFState.endOf(truncLeftEntry) - offset);
                entVal = truncLeftEntry.getValue();
                truncVn = new Varnode(space.getAddress(entStart), entVal.size());
                truncVal = JitDataFlowState.this.arithmetic.truncFromRight(truncVn, shave, entVal);
                map.put(truncLeftEntry.getKey(), truncVal);
            }
            map.subMap(offset, end).clear();
        }

        protected void doSet(NavigableMap<Long, JitVal> map, Varnode varnode, JitVal val) {
            JitOutVar out;
            JitDefOp jitDefOp;
            this.doClear(map, varnode);
            if (val instanceof JitOutVar && (jitDefOp = (out = (JitOutVar)val).definition()) instanceof JitCatenateOp) {
                JitCatenateOp cat = (JitCatenateOp)jitDefOp;
                int cursor = 0;
                for (JitVal part : cat.iterParts(JitDataFlowState.this.language.isBigEndian())) {
                    map.put(varnode.getOffset() + (long)cursor, part);
                    cursor += part.size();
                }
                return;
            }
            map.put(varnode.getOffset(), val);
        }

        public void set(Varnode varnode, JitVal val) {
            NavigableMap<Long, JitVal> map = this.mapFor(varnode.getAddress().getAddressSpace());
            if (map == null) {
                return;
            }
            this.doSet(map, varnode, val);
        }

        protected List<JitVal> doGetDefinitions(NavigableMap<Long, JitVal> map, AddressSpace space, long offset, int size) {
            long end = offset + (long)size;
            ArrayList<JitVal> result = new ArrayList<JitVal>();
            Map.Entry<Long, JitVal> preEntry = map.lowerEntry(offset);
            long cursor = offset;
            if (preEntry != null && MiniDFState.endOf(preEntry) > offset) {
                JitVal preVal = preEntry.getValue();
                Varnode preVn = new Varnode(space.getAddress(preEntry.getKey().longValue()), preVal.size());
                int shaveLeft = (int)(offset - preEntry.getKey());
                JitVal truncVal = JitDataFlowState.this.arithmetic.truncFromLeft(preVn, shaveLeft, preVal);
                if (MiniDFState.endOf(preEntry) > end) {
                    Varnode truncVn = JitDataFlowState.this.arithmetic.truncVnFromLeft(preVn, shaveLeft);
                    int shaveRight = (int)(MiniDFState.endOf(preEntry) - end);
                    truncVal = JitDataFlowState.this.arithmetic.truncFromRight(truncVn, shaveRight, truncVal);
                    cursor = end;
                    result.add(truncVal);
                } else {
                    cursor = MiniDFState.endOf(preEntry);
                    result.add(truncVal);
                }
            }
            for (Map.Entry<Long, JitVal> entry : map.subMap(offset, end).entrySet()) {
                if (entry.getKey() > cursor) {
                    result.add(new JitMissingVar(new Varnode(space.getAddress(cursor), (int)(entry.getKey() - cursor))));
                }
                if (MiniDFState.endOf(entry) > end) {
                    JitVal postVal = entry.getValue();
                    Varnode postVn = new Varnode(space.getAddress(entry.getKey().longValue()), postVal.size());
                    int shave = (int)(MiniDFState.endOf(entry) - end);
                    JitVal truncVal = JitDataFlowState.this.arithmetic.truncFromRight(postVn, shave, postVal);
                    cursor = end;
                    result.add(truncVal);
                    break;
                }
                result.add(entry.getValue());
                cursor = MiniDFState.endOf(entry);
            }
            if (end > cursor) {
                result.add(new JitMissingVar(new Varnode(space.getAddress(cursor), (int)(end - cursor))));
            }
            assert (!result.isEmpty());
            return result;
        }

        public List<JitVal> getDefinitions(AddressSpace space, long offset, int size) {
            NavigableMap<Long, JitVal> map = this.mapFor(space);
            if (map == null) {
                throw new AssertionError((Object)("What is this space?: " + String.valueOf(space)));
            }
            return this.doGetDefinitions(map, space, offset, size);
        }

        public List<JitVal> getDefinitions(Varnode varnode) {
            AddressSpace space = varnode.getAddress().getAddressSpace();
            return this.getDefinitions(space, varnode.getOffset(), varnode.getSize());
        }

        public List<JitVal> getDefinitions(Register register) {
            return this.getDefinitions(register.getAddressSpace(), register.getOffset(), register.getNumBytes());
        }

        protected List<JitVal> generatePhis(List<JitVal> defs, Collection<JitPhiOp> phiQueue) {
            int n = defs.size();
            for (int i = 0; i < n; ++i) {
                JitVal v = defs.get(i);
                if (!(v instanceof JitMissingVar)) continue;
                JitMissingVar missing = (JitMissingVar)v;
                JitPhiOp phi = missing.generatePhi(JitDataFlowState.this.dfm, JitDataFlowState.this.block);
                if (phiQueue != null) {
                    phiQueue.add(phi);
                }
                defs.set(i, phi.out());
                this.set(missing.varnode(), phi.out());
            }
            return defs;
        }

        public JitVal getVar(Varnode varnode) {
            List<JitVal> defs = this.generatePhis(this.getDefinitions(varnode), null);
            if (defs.size() == 1) {
                return defs.get(0);
            }
            return JitDataFlowState.this.arithmetic.catenate(varnode, defs);
        }

        public MiniDFState copy() {
            return new MiniDFState(new TreeMap<Long, JitVal>((SortedMap<Long, JitVal>)this.uniqMap), new TreeMap<Long, JitVal>((SortedMap<Long, JitVal>)this.regMap));
        }
    }
}

