/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.hfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import java.io.IOException;

public class HFSPlusVolumeHeader {
    private short signature;
    private short version;
    private int attributes;
    private int lastMountedVersion;
    private int journalInfoBlock;
    private int createDate;
    private int modifyDate;
    private int backupDate;
    private int checkedDate;
    private int fileCount;
    private int folderCount;
    private int blockSize;
    private int totalBlocks;
    private int freeBlocks;
    private int nextAllocation;
    private int rsrcClumpSize;
    private int dataClumpSize;
    private int nextCatalogID;
    private int writeCount;
    private long encodingsBitmap;
    private int[] finderInfo;
    private byte[] rawForkData;
    private static final int HFSPLUS_SIGNATURE_MAGIC = 18475;
    private static final int HFSX_SIGNATURE_MAGIC = 18520;
    private static final int HFSPLUS_VERSION = 4;
    private static final int HFSX_VERSION = 5;
    private static final int SIZEOF_HEADER = 512;
    private static final int DEFAULT_OFFSET = 1024;

    public static boolean probe(ByteProvider provider) {
        try {
            if (provider.length() < 1536L) {
                return false;
            }
            HFSPlusVolumeHeader header = HFSPlusVolumeHeader.read(provider);
            return header.isValid() && header.hasGoodVolumeInfo(provider);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static HFSPlusVolumeHeader read(ByteProvider provider) throws IOException {
        return HFSPlusVolumeHeader.read(provider, 1024L);
    }

    public static HFSPlusVolumeHeader read(ByteProvider provider, long offset) throws IOException {
        BinaryReader reader = new BinaryReader(provider, false);
        reader.setPointerIndex(offset);
        HFSPlusVolumeHeader result = new HFSPlusVolumeHeader();
        result.signature = reader.readNextShort();
        result.version = reader.readNextShort();
        result.attributes = reader.readNextInt();
        result.lastMountedVersion = reader.readNextInt();
        result.journalInfoBlock = reader.readNextInt();
        result.createDate = reader.readNextInt();
        result.modifyDate = reader.readNextInt();
        result.backupDate = reader.readNextInt();
        result.checkedDate = reader.readNextInt();
        result.fileCount = reader.readNextInt();
        result.folderCount = reader.readNextInt();
        result.blockSize = reader.readNextInt();
        result.totalBlocks = reader.readNextInt();
        result.freeBlocks = reader.readNextInt();
        result.nextAllocation = reader.readNextInt();
        result.rsrcClumpSize = reader.readNextInt();
        result.dataClumpSize = reader.readNextInt();
        result.nextCatalogID = reader.readNextInt();
        result.writeCount = reader.readNextInt();
        result.encodingsBitmap = reader.readNextLong();
        result.finderInfo = reader.readNextIntArray(8);
        result.rawForkData = reader.readNextByteArray(400);
        return result;
    }

    public boolean isValid() {
        return this.signature == 18475 && this.version == 4 && HFSPlusVolumeHeader.isGoodBlockSize(this.blockSize);
    }

    private static boolean isGoodBlockSize(int bs) {
        return bs > 0 && bs % 512 == 0;
    }

    public boolean hasGoodVolumeInfo(ByteProvider bp) throws IOException {
        long calculatedSize = this.blockSize * this.totalBlocks;
        return bp.length() >= calculatedSize;
    }
}

