/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.SectionContribution600;
import java.io.IOException;
import java.io.Writer;

public class ModuleInformation600
extends ModuleInformation {
    public ModuleInformation600(AbstractPdb pdb) {
        super(pdb);
        this.sectionContribution = new SectionContribution600();
    }

    @Override
    protected void parseAdditionals(PdbByteReader reader) throws PdbException {
        this.ecSymbolicInformationEnabled = (this.spare & 1) == 1;
        this.spare >>= 1;
        this.nameIndexSourceFile = reader.parseUnsignedIntVal();
        this.nameIndexCompilerPdbPath = reader.parseUnsignedIntVal();
        this.moduleName = reader.parseNullTerminatedString(this.pdb.getPdbReaderOptions().getOneByteCharset());
        this.objectFileName = reader.parseNullTerminatedString(this.pdb.getPdbReaderOptions().getOneByteCharset());
    }

    public long getNameIndexSourceFile() {
        return this.nameIndexSourceFile;
    }

    public long getNameCompilerPdbPath() {
        return this.nameIndexCompilerPdbPath;
    }

    @Override
    protected void dumpAdditionals(Writer writer) throws IOException {
        writer.write("\nnameIndexSourceFile: " + this.nameIndexSourceFile);
        writer.write("\nnameIndexCompilerPdbPath: " + this.nameIndexCompilerPdbPath);
    }
}

