/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class LinkerUnwindInfo {
    private int version;
    private int flags;
    private long dataLength;

    public int getVersion() {
        return this.version;
    }

    public int getFlags() {
        return this.flags;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public void deserialize(PdbByteReader reader) throws PdbException {
        this.version = reader.parseUnsignedShortVal();
        this.flags = reader.parseUnsignedShortVal();
        this.dataLength = reader.parseUnsignedIntVal();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.dump(writer);
            return writer.toString();
        }
        catch (IOException e) {
            return "Issue in " + this.getClass().getSimpleName() + " toString(): " + e.getMessage();
        }
    }

    void dump(Writer writer) throws IOException {
        PdbReaderUtils.dumpHead(writer, this);
        this.dumpInternal(writer);
        PdbReaderUtils.dumpTail(writer, this);
    }

    protected void dumpInternal(Writer writer) throws IOException {
        writer.write(String.format("version: 0X%04X\n", this.version));
        writer.write(String.format("flags: 0X%04X\n", this.flags));
        writer.write(String.format("dataLength: 0X%08X\n", this.dataLength));
    }
}

